import { IConstruct } from '@aws-cdk/core';
import { PolicyStatement } from '../policy-statement';
/**
 * Merge as many statements as possible to shrink the total policy doc, modifying the input array in place
 *
 * We compare and merge all pairs of statements (O(N^2) complexity), opportunistically
 * merging them. This is not guaranteed to produce the optimal output, but it's probably
 * Good Enough(tm). If it merges anything, it's at least going to produce a smaller output
 * than the input.
 */
export declare function mergeStatements(scope: IConstruct, statements: PolicyStatement[], limitSize: boolean): MergeStatementResult;
export interface MergeStatementResult {
    /**
     * The list of maximally merged statements
     */
    readonly mergedStatements: PolicyStatement[];
    /**
     * Mapping of old to new statements
     */
    readonly originsMap: Map<PolicyStatement, PolicyStatement[]>;
}
