# Generated by PyGodot binding generator
<%!
    from godot_tools.binding_generator import (
        python_module_name, remove_nested_type_prefix, CORE_TYPES, SPECIAL_ESCAPES, clean_signature
    )

    enum_values = set()

    def clean_value_name(value_name):
        enum_values.add(value_name)
        return remove_nested_type_prefix(value_name)

    singleton_map = {}

    def get_class_name(name, cls):
        if cls['singleton']:
            singleton_map[name] = name + 'Class'
            return name + 'Class'
        return name

    def get_base_name(name):
        if not name:
            return '_Wrapped'

        if name in singleton_map:
            return singleton_map[name]

        return name
%>
from godot_headers.gdnative_api cimport godot_method_bind, godot_object

from ..core cimport cpp_types as cpp
from ..core cimport types as py
from ..core.defs cimport *
from ..core._wrapped cimport _Wrapped

cdef __register_types()
cdef __init_method_bindings()
% for class_name, class_def, includes, forwards, methods in classes:
% if class_def['singleton']:

cdef ${class_name}Class ${class_name}
% endif

% if methods:
cdef struct __${class_name}__method_bindings:
% for method_name, method, return_type, pxd_signature, signature, args, return_stmt, init_args in methods:
    godot_method_bind *mb_${method_name}
% endfor
% endif

cdef class ${get_class_name(class_name, class_def)}(${get_base_name(class_def['base_class'])}):
    @staticmethod
    cdef __init_method_bindings()
    % if class_def['singleton']:

    @staticmethod
    cdef object get_singleton()
    % endif

    % for method_name, method, return_type, pxd_signature, signature, args, return_stmt, init_args in methods:
    % if method['__func_type'] == 'cdef':
    cdef ${return_type}${method_name}(self${', ' if pxd_signature else ''}${clean_signature(pxd_signature, class_name)})
    % endif
    % if method_name == '__call__' and class_name == 'NativeScript':

    cdef godot_object *_new_instance(self)
    % endif
    % endfor

    % for enum in class_def['enums']:
cdef enum ${class_name}${enum['name'].lstrip('_')}:
        % for value_name, value in enum['values'].items():
    ${python_module_name(class_name).upper()}_${clean_value_name(value_name)} = ${value}
        % endfor

    % endfor
    % for name, value in ((k, v) for (k, v) in class_def['constants'].items() if k not in enum_values):
cdef int ${python_module_name(class_name).upper()}_${name} = ${value}
    % endfor
% endfor
