# Generated by PyGodot binding generator
<%!
    from godot_tools.binding_generator import escape_python, remove_nested_type_prefix

    DYNAMIC_PROPERTIES = True

    def class_name(cls):
        name = cls['name'].lstrip('_')
        if cls['singleton']:
            return name + 'Class'
        return name

    def prop_getter(prop, class_def):
        getter = prop['getter']
        index = prop['index']

        if class_def['name'] == 'Node2D' and getter == 'get_global_transform':
            return 'CanvasItem.get_global_transform'
        elif class_def['name'] == 'Node2D' and getter == 'get_transform':
            return 'CanvasItem.get_transform'
        elif class_def['name'] in ('Slider', 'LineEdit') and getter == 'get_focus_mode':
            return 'Control.get_focus_mode'
        elif class_def['name'] == 'BitmapFont' and getter in ('get_ascent', 'is_distance_field_hint', 'get_height'):
            return 'Font.%s' % getter
        elif class_def['name'] in ('CurveTexture', 'GradientTexture', 'NoiseTexture') and getter == 'get_width':
            return 'Texture.get_width'
        elif class_def['name'] in ('DirectionalLight', 'OmniLight', 'SpotLight') and getter == 'get_param':
            return 'partialmethod(Light.%s, %d)' % (getter, index)
        elif class_def['name'] in ('InputEventAction', 'InputEventJoypadButton', 'InputEventKey', 'InputEventMouseButton', 'InputEventScreenTouch') and getter == 'is_pressed':
            return 'InputEvent.is_pressed'
        elif class_def['name'] == 'InputEventKey' and getter == 'is_echo':
            return 'InputEvent.is_echo'
        elif class_def['name'] == 'NoiseTexture' and getter == 'get_height':
            return 'Texture.get_height'

        if index >= 0:
            return 'partialmethod(%s.%s, %d)' % (class_name(class_def), escape_python(getter), index)

        return '%s.%s' % (class_name(class_def), escape_python(getter))

    def prop_setter(prop, class_def):
        setter = prop['setter']
        index = prop['index']

        if class_def['name'] in ('Slider', 'LineEdit') and setter == 'set_focus_mode':
            return 'Control.set_focus_mode'
        elif class_def['name'] in ('DirectionalLight', 'OmniLight', 'SpotLight') and setter == 'set_param':
            return 'partialmethod(Light.%s, %d)' % (setter, index)

        if not setter:
            return ''

        if index >= 0:
            return 'partialmethod(%s.%s, %d)' % (class_name(class_def), escape_python(setter), index)

        return '%s.%s' % (class_name(class_def), escape_python(setter))
%>
import enum
% if DYNAMIC_PROPERTIES:
from functools import partialmethod

% endif
from godot.bindings._python_bindings import (
% for class_name in class_names:
    % if classes[class_name]['singleton']:
    ${class_name}Class,
    ${class_name},
    % else:
    ${class_name},
    % endif
% endfor
)

__all__ = (
% for class_name in class_names:
    ${repr(class_name)},
% endfor
)

% for class_name, class_def in classes.items():
% if (DYNAMIC_PROPERTIES and class_def['properties']) or class_def['enums'] or class_def['constants']:
${class_name}${'Class' if class_def['singleton'] else ''}.__finalize_type(
## FIXME: RootMotionView has an incomplete API, no methods are defined
% if DYNAMIC_PROPERTIES and class_def['properties'] and class_def['name'] not in ('RootMotionView',):
% for prop in class_def['properties']:
    ${escape_python(prop['name'])}=property(${prop_getter(prop, class_def)}${', ' if prop['setter'] else ''}${prop_setter(prop, class_def)}),
% endfor
% endif  ## if props
% for enum in class_def['enums']:
    ## TODO: Some ot the enums should be defined as enum.IntFlag
    ${enum['name']}=enum.IntEnum(
        ${repr(enum['name'])},
        dict(
    % for value_name, value in enum['values'].items():
            ${remove_nested_type_prefix(value_name)}=${value},
    % endfor  ## enum values
        )
    ),
% endfor  ## enums
% for name, value in class_def['constants'].items():
    ${name}=${value},
% endfor
)
% endif  ## if props or enums or constants
% if class_def['singleton']:
if ${class_name} is None:
    ${class_name} = ${class_name}Class.get_singleton()
% endif
% endfor  ## classes
