#!python
<%!
import sys
%>
# Generated by GodoPy ${__version__}

import sys
import os

if not hasattr(sys, 'version_info') or sys.version_info < (3, 6):
    raise SystemExit("PyGodot requires Python version 3.6 or above.")

if sys.platform.startswith('linux'):
    host_platform = 'linux'
elif sys.platform == 'darwin':
    host_platform = 'osx'
elif sys.platform == 'win32' or sys.platform == 'msys':
    host_platform = 'windows'
else:
    raise ValueError(
        'Could not detect platform automatically, please specify with '
        'platform=<platform>'
    )

opts = Variables([], ARGUMENTS)

opts.Add(EnumVariable('target', "Compilation target", 'release', ['d', 'debug', 'r', 'release']))
opts.Add(EnumVariable('platform', "Compilation platform", host_platform, ['windows', 'x11', 'linux', 'osx']))
opts.Add(EnumVariable('p', "Compilation target, alias for 'platform'", host_platform, ['windows', 'linux', 'osx']))
opts.Add(BoolVariable('use_llvm', "Use the LLVM / Clang compiler", 'no'))
opts.Add(BoolVariable('python_debug', 'Use debug build of Python', False))

godot_headers_path = ${repr(godot_headers_path)}
godopy_bindings_path = ${repr(godopy_bindings_path)}
godopy_library = ${repr(godopy_library_name)}

if sys.platform == 'win32':
    env = Environment(TARGET_ARCH='amd64')
else:
    env = DefaultEnvironment()

opts.Update(env)

if env['use_llvm']:
    env['CC'] = 'clang'
    env['CXX'] = 'clang++'

if env['p'] != '':
    env['platform'] = env['p']

if env['platform'] == '':
    print("No valid target platform selected.")
    quit()

python_include = 'python3.8d' if env['python_debug'] else 'python3.8'
python_lib = 'python3.8d' if env['python_debug'] else 'python3.8'
python_internal_env = os.path.join(godopy_bindings_path, 'venv', 'lib', 'python3.8', 'site-packages')

if env['platform'] == "osx":
    # Use Clang on macOS by default
    env['CXX'] = 'clang++'

    libdir = 'config-3.8d-darwin' if env['python_debug'] else 'config-3.8-darwin'
    env.Append(LIBPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'build', 'lib', 'python3.8', libdir)])
    env.Append(CPPPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'build', 'include', python_include)])
    env.Append(CCFLAGS=[
        '-g',
        '-std=c++14',
        '-arch', 'x86_64',
        '-fwrapv',
        '-Wno-unused-result',
        '-Wsign-compare',
        # '-Wunreachable-code'
    ])
    env.Append(LINKFLAGS=[
        '-arch',
        'x86_64',
        '-framework', 'Cocoa',
        '-Wl,-undefined,dynamic_lookup',
    ])

    env.Append(LIBS=[python_lib, 'dl'])

    if env['target'] == 'debug':
        env.Append(CCFLAGS=['-Og'])
    elif env['target'] == 'release':
        env.Append(CCFLAGS=['-O3'])

elif env['platform'] == 'linux':
    env.Append(LIBPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'build', 'lib')])
    env.Append(CPPPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'build', 'include', python_include)])
    env.Append(CCFLAGS=[
        '-fPIC',
        '-g',
        '-std=c++14',
        '-Wwrite-strings',
        '-fwrapv',
        '-Wno-unused-result',
        '-Wsign-compare'
    ])
    env.Append(LIBS=[python_lib, 'crypt', 'pthread', 'dl', 'util', 'm'])
    env.Append(LINKFLAGS=["-Wl,-R,'$$ORIGIN'"])
    # env.Append(LINKFLAGS=['-Wl,-undefined,dynamic_lookup'])
    if env['target'] in ('debug', 'd'):
        env.Append(CCFLAGS=['-g3', '-Og'])
    else:
        env.Append(CCFLAGS=['-g', '-O3'])

elif env['platform'] == 'windows':
    python_internal_env = os.path.join(godopy_bindings_path, 'venv', 'Lib', 'site-packages')

    env.Append(LIBPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'PCBuild', 'amd64')])
    env.Append(CPPPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'PC')])
    env.Append(CPPPATH=[os.path.join(godopy_bindings_path, 'deps', 'python', 'Include')])
    env.Append(CPPDEFINES=['WIN32', '_WIN32', '_WINDOWS', '_CRT_SECURE_NO_WARNINGS'])
    env.Append(CCFLAGS=['-W3', '-GR'])

    python_lib = 'python38_d' if env['python_debug'] else 'python38'
    env.Append(LIBS=[python_lib])

    if env['target'] in ('debug', 'd'):
        env.Append(CPPDEFINES=['_DEBUG'])
        env.Append(CCFLAGS=['-EHsc', '-MDd', '-ZI'])
        env.Append(LINKFLAGS=['-DEBUG'])
    else:
        env.Append(CPPDEFINES=['NDEBUG'])
        env.Append(CCFLAGS=['-O2', '-EHsc', '-MD'])

cython_builder = os.path.join(
    godopy_bindings_path,
    'venv',
    'Scripts' if sys.platform == 'win32' else 'bin',
    'godopy_cython.exe' if sys.platform == 'win32' else 'godopy_cython'
)

env.Append(BUILDERS={
    # 'CythonSource': Builder(action='%s/cython --fast-fail -3 --cplus -o $TARGET $SOURCE' % binpath)
    'CythonSource': Builder(action='%s $SOURCE $TARGET' % cython_builder)
})

# make sure our binding library is properly includes
env.Append(CPPPATH=[
    godot_headers_path,
    godopy_bindings_path,
    os.path.join(godopy_bindings_path, 'include'),
    os.path.join(godopy_bindings_path, 'include', 'core'),
    os.path.join(godopy_bindings_path, 'include', 'gen'),
    os.path.join(godopy_bindings_path, 'include', 'pycore'),
    os.path.join(godopy_bindings_path, 'include', 'pygen'),
    os.path.join(python_internal_env, 'numpy', 'core', 'include')
])
env.Append(LIBPATH=[os.path.join(godopy_bindings_path, 'bin')])
env.Append(LIBS=[godopy_library])

% for mod in pyx_sources:
_gencpp_${mod['symbol_name']} = env.CythonSource(${repr(mod['cpp'])}, ${repr(mod['pyx'])})
% endfor

sources = [
% for mod in pyx_sources:
    _gencpp_${mod['symbol_name']},
% endfor
% for src in cpp_sources:
    ${repr(src)},
% endfor
]

target_noext, ext = os.path.splitext(${repr(target)})
env['SHLIBSUFFIX'] = ext
env['SHLIBPREFIX'] = ''
library = env.SharedLibrary(target='${target}', source=sources)

Default(library)

# Generates help for the -h scons option.
Help(opts.GenerateHelpText(env))
