"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class Status(str, Enum, metaclass=utils.OpenEnumMeta):
    ACTIVE = "ACTIVE"
    ARCHIVED = "ARCHIVED"


class Type(str, Enum, metaclass=utils.OpenEnumMeta):
    ACCOUNTS_PAYABLE = "ACCOUNTS_PAYABLE"
    ACCOUNTS_RECEIVABLE = "ACCOUNTS_RECEIVABLE"
    BANK = "BANK"
    CREDIT_CARD = "CREDIT_CARD"
    FIXED_ASSET = "FIXED_ASSET"
    LIABILITY = "LIABILITY"
    EQUITY = "EQUITY"
    EXPENSE = "EXPENSE"
    REVENUE = "REVENUE"
    OTHER = "OTHER"


class AccountingAccountTypedDict(TypedDict):
    r"""Chart of accounts"""

    balance: NotRequired[float]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    customer_defined_code: NotRequired[str]
    description: NotRequired[str]
    group: NotRequired[str]
    id: NotRequired[str]
    is_payable: NotRequired[bool]
    name: NotRequired[str]
    parent_account_id: NotRequired[str]
    parent_id: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    section: NotRequired[str]
    status: NotRequired[Status]
    subgroup: NotRequired[str]
    subsection: NotRequired[str]
    type: NotRequired[Type]
    updated_at: NotRequired[datetime]


class AccountingAccount(BaseModel):
    r"""Chart of accounts"""

    balance: Optional[float] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    customer_defined_code: Optional[str] = None

    description: Optional[str] = None

    group: Optional[str] = None

    id: Optional[str] = None

    is_payable: Optional[bool] = None

    name: Optional[str] = None

    parent_account_id: Optional[str] = None

    parent_id: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    section: Optional[str] = None

    status: Annotated[Optional[Status], PlainValidator(validate_open_enum(False))] = (
        None
    )

    subgroup: Optional[str] = None

    subsection: Optional[str] = None

    type: Annotated[Optional[Type], PlainValidator(validate_open_enum(False))] = None

    updated_at: Optional[datetime] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.Status(value)
            except ValueError:
                return value
        return value

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.Type(value)
            except ValueError:
                return value
        return value
