"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AccountingContactPaymentMethodType(str, Enum, metaclass=utils.OpenEnumMeta):
    ACH = "ACH"
    ALIPAY = "ALIPAY"
    CARD = "CARD"
    GIROPAY = "GIROPAY"
    IDEAL = "IDEAL"
    OTHER = "OTHER"
    PAYPAL = "PAYPAL"
    WIRE = "WIRE"
    CHECK = "CHECK"


class AccountingContactPaymentMethodTypedDict(TypedDict):
    type: AccountingContactPaymentMethodType
    default: NotRequired[bool]
    id: NotRequired[str]
    name: NotRequired[str]


class AccountingContactPaymentMethod(BaseModel):
    type: Annotated[
        AccountingContactPaymentMethodType, PlainValidator(validate_open_enum(False))
    ]

    default: Optional[bool] = None

    id: Optional[str] = None

    name: Optional[str] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.AccountingContactPaymentMethodType(value)
            except ValueError:
                return value
        return value
