"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountinglineitem import AccountingLineitem, AccountingLineitemTypedDict
from .property_accountingpurchaseorder_billing_address import (
    PropertyAccountingPurchaseorderBillingAddress,
    PropertyAccountingPurchaseorderBillingAddressTypedDict,
)
from .property_accountingpurchaseorder_shipping_address import (
    PropertyAccountingPurchaseorderShippingAddress,
    PropertyAccountingPurchaseorderShippingAddressTypedDict,
)
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AccountingPurchaseorderStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    DRAFT = "DRAFT"
    VOIDED = "VOIDED"
    AUTHORIZED = "AUTHORIZED"
    PAID = "PAID"
    PARTIALLY_PAID = "PARTIALLY_PAID"
    PARTIALLY_REFUNDED = "PARTIALLY_REFUNDED"
    REFUNDED = "REFUNDED"


class AccountingPurchaseorderTypedDict(TypedDict):
    account_id: NotRequired[str]
    billing_address: NotRequired[PropertyAccountingPurchaseorderBillingAddressTypedDict]
    contact_id: NotRequired[str]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    id: NotRequired[str]
    lineitems: NotRequired[List[AccountingLineitemTypedDict]]
    posted_at: NotRequired[datetime]
    raw: NotRequired[Dict[str, Any]]
    shipping_address: NotRequired[
        PropertyAccountingPurchaseorderShippingAddressTypedDict
    ]
    status: NotRequired[AccountingPurchaseorderStatus]
    total_amount: NotRequired[float]
    updated_at: NotRequired[datetime]


class AccountingPurchaseorder(BaseModel):
    account_id: Optional[str] = None

    billing_address: Optional[PropertyAccountingPurchaseorderBillingAddress] = None

    contact_id: Optional[str] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    id: Optional[str] = None

    lineitems: Optional[List[AccountingLineitem]] = None

    posted_at: Optional[datetime] = None

    raw: Optional[Dict[str, Any]] = None

    shipping_address: Optional[PropertyAccountingPurchaseorderShippingAddress] = None

    status: Annotated[
        Optional[AccountingPurchaseorderStatus],
        PlainValidator(validate_open_enum(False)),
    ] = None

    total_amount: Optional[float] = None

    updated_at: Optional[datetime] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.AccountingPurchaseorderStatus(value)
            except ValueError:
                return value
        return value
