"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class Frequency(str, Enum, metaclass=utils.OpenEnumMeta):
    ONE_TIME = "ONE_TIME"
    DAY = "DAY"
    QUARTER = "QUARTER"
    YEAR = "YEAR"
    HOUR = "HOUR"
    MONTH = "MONTH"
    WEEK = "WEEK"


class AtsCompensationType(str, Enum, metaclass=utils.OpenEnumMeta):
    SALARY = "SALARY"
    BONUS = "BONUS"
    STOCK_OPTIONS = "STOCK_OPTIONS"
    EQUITY = "EQUITY"
    OTHER = "OTHER"


class AtsCompensationTypedDict(TypedDict):
    currency: NotRequired[str]
    frequency: NotRequired[Frequency]
    max: NotRequired[float]
    min: NotRequired[float]
    type: NotRequired[AtsCompensationType]


class AtsCompensation(BaseModel):
    currency: Optional[str] = None

    frequency: Annotated[
        Optional[Frequency], PlainValidator(validate_open_enum(False))
    ] = None

    max: Optional[float] = None

    min: Optional[float] = None

    type: Annotated[
        Optional[AtsCompensationType], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("frequency")
    def serialize_frequency(self, value):
        if isinstance(value, str):
            try:
                return shared.Frequency(value)
            except ValueError:
                return value
        return value

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.AtsCompensationType(value)
            except ValueError:
                return value
        return value
