"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AtsGroupType(str, Enum, metaclass=utils.OpenEnumMeta):
    TEAM = "TEAM"
    GROUP = "GROUP"
    DEPARTMENT = "DEPARTMENT"
    DIVISION = "DIVISION"
    BUSINESS_UNIT = "BUSINESS_UNIT"
    BRANCH = "BRANCH"
    SUB_DEPARTMENT = "SUB_DEPARTMENT"


class AtsGroupTypedDict(TypedDict):
    id: NotRequired[str]
    name: NotRequired[str]
    type: NotRequired[AtsGroupType]


class AtsGroup(BaseModel):
    id: Optional[str] = None

    name: Optional[str] = None

    type: Annotated[
        Optional[AtsGroupType], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.AtsGroupType(value)
            except ValueError:
                return value
        return value
