"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AtsJobOpeningStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    OPEN = "OPEN"
    CLOSED = "CLOSED"


class AtsJobOpeningTypedDict(TypedDict):
    application_id: NotRequired[str]
    close_reason: NotRequired[str]
    closed_at: NotRequired[datetime]
    opened_at: NotRequired[datetime]
    status: NotRequired[AtsJobOpeningStatus]


class AtsJobOpening(BaseModel):
    application_id: Optional[str] = None

    close_reason: Optional[str] = None

    closed_at: Optional[datetime] = None

    opened_at: Optional[datetime] = None

    status: Annotated[
        Optional[AtsJobOpeningStatus], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.AtsJobOpeningStatus(value)
            except ValueError:
                return value
        return value
