"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AtsJobQuestionType(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    BOOLEAN = "BOOLEAN"
    MULTIPLE_CHOICE = "MULTIPLE_CHOICE"
    FILE = "FILE"
    TEXTAREA = "TEXTAREA"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    UNIVERSITY = "UNIVERSITY"
    YES_NO = "YES_NO"
    CURRENCY = "CURRENCY"
    URL = "URL"


class AtsJobQuestionTypedDict(TypedDict):
    question: str
    type: AtsJobQuestionType
    description: NotRequired[str]
    id: NotRequired[str]
    options: NotRequired[List[str]]
    prompt: NotRequired[str]
    required: NotRequired[bool]


class AtsJobQuestion(BaseModel):
    question: str

    type: Annotated[AtsJobQuestionType, PlainValidator(validate_open_enum(False))]

    description: Optional[str] = None

    id: Optional[str] = None

    options: Optional[List[str]] = None

    prompt: Optional[str] = None

    required: Optional[bool] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.AtsJobQuestionType(value)
            except ValueError:
                return value
        return value
