"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class OneTypedDict(TypedDict):
    pass


class One(BaseModel):
    pass


FiveTypedDict = TypeAliasType("FiveTypedDict", Union[OneTypedDict, str, float, bool])


Five = TypeAliasType("Five", Union[One, str, float, bool])


ExtraDataTypedDict = TypeAliasType(
    "ExtraDataTypedDict", Union[Dict[str, Any], str, float, bool, List[FiveTypedDict]]
)


ExtraData = TypeAliasType(
    "ExtraData", Union[Dict[str, Any], str, float, bool, List[Five]]
)


class Format(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    BOOLEAN = "BOOLEAN"
    FILE = "FILE"
    TEXTAREA = "TEXTAREA"
    SINGLE_SELECT = "SINGLE_SELECT"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    MEASUREMENT = "MEASUREMENT"
    PRICE = "PRICE"
    YES_NO = "YES_NO"
    CURRENCY = "CURRENCY"
    URL = "URL"


class AtsMetadata1TypedDict(TypedDict):
    pass


class AtsMetadata1(BaseModel):
    pass


AtsMetadata5TypedDict = TypeAliasType(
    "AtsMetadata5TypedDict", Union[AtsMetadata1TypedDict, str, float, bool]
)


AtsMetadata5 = TypeAliasType("AtsMetadata5", Union[AtsMetadata1, str, float, bool])


ValueTypedDict = TypeAliasType(
    "ValueTypedDict",
    Union[Dict[str, Any], str, float, bool, List[AtsMetadata5TypedDict]],
)


Value = TypeAliasType(
    "Value", Union[Dict[str, Any], str, float, bool, List[AtsMetadata5]]
)


class AtsMetadataTypedDict(TypedDict):
    extra_data: NotRequired[ExtraDataTypedDict]
    format_: NotRequired[Format]
    id: NotRequired[str]
    key: NotRequired[str]
    namespace: NotRequired[str]
    slug: NotRequired[str]
    type: NotRequired[str]
    value: NotRequired[ValueTypedDict]


class AtsMetadata(BaseModel):
    extra_data: Optional[ExtraData] = None

    format_: Annotated[
        Annotated[Optional[Format], PlainValidator(validate_open_enum(False))],
        pydantic.Field(alias="format"),
    ] = None

    id: Optional[str] = None

    key: Optional[str] = None

    namespace: Optional[str] = None

    slug: Optional[str] = None

    type: Optional[str] = None

    value: Optional[Value] = None

    @field_serializer("format_")
    def serialize_format_(self, value):
        if isinstance(value, str):
            try:
                return shared.Format(value)
            except ValueError:
                return value
        return value
