"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AtsTelephoneType(str, Enum, metaclass=utils.OpenEnumMeta):
    WORK = "WORK"
    HOME = "HOME"
    OTHER = "OTHER"
    FAX = "FAX"
    MOBILE = "MOBILE"


class AtsTelephoneTypedDict(TypedDict):
    telephone: str
    type: NotRequired[AtsTelephoneType]


class AtsTelephone(BaseModel):
    telephone: str

    type: Annotated[
        Optional[AtsTelephoneType], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.AtsTelephoneType(value)
            except ValueError:
                return value
        return value
