"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .commercemetadata import CommerceMetadata, CommerceMetadataTypedDict
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class CommerceItemMediaType(str, Enum, metaclass=utils.OpenEnumMeta):
    IMAGE = "image"
    VIDEO = "video"


class CommerceItemMediaTypedDict(TypedDict):
    url: str
    alt: NotRequired[str]
    height: NotRequired[float]
    id: NotRequired[str]
    metadata: NotRequired[List[CommerceMetadataTypedDict]]
    position: NotRequired[float]
    type: NotRequired[CommerceItemMediaType]
    width: NotRequired[float]


class CommerceItemMedia(BaseModel):
    url: str

    alt: Optional[str] = None

    height: Optional[float] = None

    id: Optional[str] = None

    metadata: Optional[List[CommerceMetadata]] = None

    position: Optional[float] = None

    type: Annotated[
        Optional[CommerceItemMediaType], PlainValidator(validate_open_enum(False))
    ] = None

    width: Optional[float] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.CommerceItemMediaType(value)
            except ValueError:
                return value
        return value
