"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .commerceitemmedia import CommerceItemMedia, CommerceItemMediaTypedDict
from .commercemetadata import CommerceMetadata, CommerceMetadataTypedDict
from .commercereviewcomment import CommerceReviewComment, CommerceReviewCommentTypedDict
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class CommerceReviewStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    PENDING = "PENDING"
    APPROVED = "APPROVED"
    REJECTED = "REJECTED"
    SPAM = "SPAM"


class CommerceReviewTypedDict(TypedDict):
    item_id: str
    author_avatar_url: NotRequired[str]
    author_email: NotRequired[str]
    author_location: NotRequired[str]
    author_name: NotRequired[str]
    comments: NotRequired[List[CommerceReviewCommentTypedDict]]
    content: NotRequired[str]
    created_at: NotRequired[datetime]
    helpful_votes: NotRequired[float]
    id: NotRequired[str]
    is_featured: NotRequired[bool]
    is_public: NotRequired[bool]
    is_verified: NotRequired[bool]
    item_variant_id: NotRequired[str]
    media: NotRequired[List[CommerceItemMediaTypedDict]]
    r"""Photosvideos attached to the review"""
    metadata: NotRequired[List[CommerceMetadataTypedDict]]
    rating: NotRequired[float]
    raw: NotRequired[Dict[str, Any]]
    status: NotRequired[CommerceReviewStatus]
    title: NotRequired[str]
    unhelpful_votes: NotRequired[float]
    updated_at: NotRequired[datetime]
    verified_purchase: NotRequired[bool]


class CommerceReview(BaseModel):
    item_id: str

    author_avatar_url: Optional[str] = None

    author_email: Optional[str] = None

    author_location: Optional[str] = None

    author_name: Optional[str] = None

    comments: Optional[List[CommerceReviewComment]] = None

    content: Optional[str] = None

    created_at: Optional[datetime] = None

    helpful_votes: Optional[float] = None

    id: Optional[str] = None

    is_featured: Optional[bool] = None

    is_public: Optional[bool] = None

    is_verified: Optional[bool] = None

    item_variant_id: Optional[str] = None

    media: Optional[List[CommerceItemMedia]] = None
    r"""Photosvideos attached to the review"""

    metadata: Optional[List[CommerceMetadata]] = None

    rating: Optional[float] = None

    raw: Optional[Dict[str, Any]] = None

    status: Annotated[
        Optional[CommerceReviewStatus], PlainValidator(validate_open_enum(False))
    ] = None

    title: Optional[str] = None

    unhelpful_votes: Optional[float] = None

    updated_at: Optional[datetime] = None

    verified_purchase: Optional[bool] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.CommerceReviewStatus(value)
            except ValueError:
                return value
        return value
