"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .commercemetadata import CommerceMetadata, CommerceMetadataTypedDict
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class CommerceReviewCommentStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    PENDING = "PENDING"
    APPROVED = "APPROVED"
    REJECTED = "REJECTED"
    SPAM = "SPAM"


class CommerceReviewCommentTypedDict(TypedDict):
    content: str
    author_avatar_url: NotRequired[str]
    author_email: NotRequired[str]
    author_location: NotRequired[str]
    author_name: NotRequired[str]
    created_at: NotRequired[datetime]
    helpful_votes: NotRequired[float]
    id: NotRequired[str]
    is_public: NotRequired[bool]
    is_verified: NotRequired[bool]
    metadata: NotRequired[List[CommerceMetadataTypedDict]]
    raw: NotRequired[Dict[str, Any]]
    status: NotRequired[CommerceReviewCommentStatus]
    unhelpful_votes: NotRequired[float]
    updated_at: NotRequired[datetime]


class CommerceReviewComment(BaseModel):
    content: str

    author_avatar_url: Optional[str] = None

    author_email: Optional[str] = None

    author_location: Optional[str] = None

    author_name: Optional[str] = None

    created_at: Optional[datetime] = None

    helpful_votes: Optional[float] = None

    id: Optional[str] = None

    is_public: Optional[bool] = None

    is_verified: Optional[bool] = None

    metadata: Optional[List[CommerceMetadata]] = None

    raw: Optional[Dict[str, Any]] = None

    status: Annotated[
        Optional[CommerceReviewCommentStatus], PlainValidator(validate_open_enum(False))
    ] = None

    unhelpful_votes: Optional[float] = None

    updated_at: Optional[datetime] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.CommerceReviewCommentStatus(value)
            except ValueError:
                return value
        return value
