"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .crmemail import CrmEmail, CrmEmailTypedDict
from .crmmetadata import CrmMetadata, CrmMetadataTypedDict
from .crmtelephone import CrmTelephone, CrmTelephoneTypedDict
from .property_crmcompany_address import (
    PropertyCrmCompanyAddress,
    PropertyCrmCompanyAddressTypedDict,
)
from datetime import datetime
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class CrmCompanyTypedDict(TypedDict):
    r"""A company represents an organization that optionally is associated with a deal and/or contacts"""

    address: NotRequired[PropertyCrmCompanyAddressTypedDict]
    contact_ids: NotRequired[List[str]]
    r"""An array of contact IDs associated with this company"""
    created_at: NotRequired[datetime]
    deal_ids: NotRequired[List[str]]
    r"""An array of deal IDs associated with this contact"""
    description: NotRequired[str]
    domains: NotRequired[List[str]]
    emails: NotRequired[List[CrmEmailTypedDict]]
    employees: NotRequired[float]
    id: NotRequired[str]
    industry: NotRequired[str]
    is_active: NotRequired[bool]
    link_urls: NotRequired[List[str]]
    r"""Additional URLs associated with the contact e.g., LinkedIn, website, etc"""
    metadata: NotRequired[List[CrmMetadataTypedDict]]
    name: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    tags: NotRequired[List[str]]
    telephones: NotRequired[List[CrmTelephoneTypedDict]]
    timezone: NotRequired[str]
    updated_at: NotRequired[datetime]
    user_id: NotRequired[str]
    websites: NotRequired[List[str]]


class CrmCompany(BaseModel):
    r"""A company represents an organization that optionally is associated with a deal and/or contacts"""

    address: Optional[PropertyCrmCompanyAddress] = None

    contact_ids: Optional[List[str]] = None
    r"""An array of contact IDs associated with this company"""

    created_at: Optional[datetime] = None

    deal_ids: Optional[List[str]] = None
    r"""An array of deal IDs associated with this contact"""

    description: Optional[str] = None

    domains: Optional[List[str]] = None

    emails: Optional[List[CrmEmail]] = None

    employees: Optional[float] = None

    id: Optional[str] = None

    industry: Optional[str] = None

    is_active: Optional[bool] = None

    link_urls: Optional[List[str]] = None
    r"""Additional URLs associated with the contact e.g., LinkedIn, website, etc"""

    metadata: Optional[List[CrmMetadata]] = None

    name: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    tags: Optional[List[str]] = None

    telephones: Optional[List[CrmTelephone]] = None

    timezone: Optional[str] = None

    updated_at: Optional[datetime] = None

    user_id: Optional[str] = None

    websites: Optional[List[str]] = None
