"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .crmemail import CrmEmail, CrmEmailTypedDict
from .crmmetadata import CrmMetadata, CrmMetadataTypedDict
from .crmtelephone import CrmTelephone, CrmTelephoneTypedDict
from .property_crmcontact_address import (
    PropertyCrmContactAddress,
    PropertyCrmContactAddressTypedDict,
)
from datetime import datetime
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class CrmContactTypedDict(TypedDict):
    r"""A contact represents a person that optionally is associated with a deal and/or a company"""

    address: NotRequired[PropertyCrmContactAddressTypedDict]
    company: NotRequired[str]
    company_ids: NotRequired[List[str]]
    r"""An array of company IDs associated with this contact"""
    created_at: NotRequired[datetime]
    deal_ids: NotRequired[List[str]]
    r"""An array of deal IDs associated with this contact"""
    department: NotRequired[str]
    emails: NotRequired[List[CrmEmailTypedDict]]
    r"""An array of email addresses for this contact"""
    first_name: NotRequired[str]
    id: NotRequired[str]
    image_url: NotRequired[str]
    last_name: NotRequired[str]
    link_urls: NotRequired[List[str]]
    r"""Additional URLs associated with the contact e.g., LinkedIn, website, etc"""
    metadata: NotRequired[List[CrmMetadataTypedDict]]
    name: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    telephones: NotRequired[List[CrmTelephoneTypedDict]]
    r"""An array of telephones for this contact"""
    title: NotRequired[str]
    updated_at: NotRequired[datetime]
    user_id: NotRequired[str]


class CrmContact(BaseModel):
    r"""A contact represents a person that optionally is associated with a deal and/or a company"""

    address: Optional[PropertyCrmContactAddress] = None

    company: Optional[str] = None

    company_ids: Optional[List[str]] = None
    r"""An array of company IDs associated with this contact"""

    created_at: Optional[datetime] = None

    deal_ids: Optional[List[str]] = None
    r"""An array of deal IDs associated with this contact"""

    department: Optional[str] = None

    emails: Optional[List[CrmEmail]] = None
    r"""An array of email addresses for this contact"""

    first_name: Optional[str] = None

    id: Optional[str] = None

    image_url: Optional[str] = None

    last_name: Optional[str] = None

    link_urls: Optional[List[str]] = None
    r"""Additional URLs associated with the contact e.g., LinkedIn, website, etc"""

    metadata: Optional[List[CrmMetadata]] = None

    name: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    telephones: Optional[List[CrmTelephone]] = None
    r"""An array of telephones for this contact"""

    title: Optional[str] = None

    updated_at: Optional[datetime] = None

    user_id: Optional[str] = None
