"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class CrmMetadata1TypedDict(TypedDict):
    pass


class CrmMetadata1(BaseModel):
    pass


CrmMetadata5TypedDict = TypeAliasType(
    "CrmMetadata5TypedDict", Union[CrmMetadata1TypedDict, str, float, bool]
)


CrmMetadata5 = TypeAliasType("CrmMetadata5", Union[CrmMetadata1, str, float, bool])


CrmMetadataExtraDataTypedDict = TypeAliasType(
    "CrmMetadataExtraDataTypedDict",
    Union[Dict[str, Any], str, float, bool, List[CrmMetadata5TypedDict]],
)


CrmMetadataExtraData = TypeAliasType(
    "CrmMetadataExtraData", Union[Dict[str, Any], str, float, bool, List[CrmMetadata5]]
)


class CrmMetadataFormat(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    BOOLEAN = "BOOLEAN"
    FILE = "FILE"
    TEXTAREA = "TEXTAREA"
    SINGLE_SELECT = "SINGLE_SELECT"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    MEASUREMENT = "MEASUREMENT"
    PRICE = "PRICE"
    YES_NO = "YES_NO"
    CURRENCY = "CURRENCY"
    URL = "URL"


class CrmMetadataSchemas1TypedDict(TypedDict):
    pass


class CrmMetadataSchemas1(BaseModel):
    pass


CrmMetadataSchemas5TypedDict = TypeAliasType(
    "CrmMetadataSchemas5TypedDict",
    Union[CrmMetadataSchemas1TypedDict, str, float, bool],
)


CrmMetadataSchemas5 = TypeAliasType(
    "CrmMetadataSchemas5", Union[CrmMetadataSchemas1, str, float, bool]
)


CrmMetadataValueTypedDict = TypeAliasType(
    "CrmMetadataValueTypedDict",
    Union[Dict[str, Any], str, float, bool, List[CrmMetadataSchemas5TypedDict]],
)


CrmMetadataValue = TypeAliasType(
    "CrmMetadataValue",
    Union[Dict[str, Any], str, float, bool, List[CrmMetadataSchemas5]],
)


class CrmMetadataTypedDict(TypedDict):
    extra_data: NotRequired[CrmMetadataExtraDataTypedDict]
    format_: NotRequired[CrmMetadataFormat]
    id: NotRequired[str]
    key: NotRequired[str]
    namespace: NotRequired[str]
    slug: NotRequired[str]
    type: NotRequired[str]
    value: NotRequired[CrmMetadataValueTypedDict]


class CrmMetadata(BaseModel):
    extra_data: Optional[CrmMetadataExtraData] = None

    format_: Annotated[
        Annotated[
            Optional[CrmMetadataFormat], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="format"),
    ] = None

    id: Optional[str] = None

    key: Optional[str] = None

    namespace: Optional[str] = None

    slug: Optional[str] = None

    type: Optional[str] = None

    value: Optional[CrmMetadataValue] = None

    @field_serializer("format_")
    def serialize_format_(self, value):
        if isinstance(value, str):
            try:
                return shared.CrmMetadataFormat(value)
            except ValueError:
                return value
        return value
