"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class CoverageLevel(str, Enum, metaclass=utils.OpenEnumMeta):
    EMPLOYEE_ONLY = "EMPLOYEE_ONLY"
    EMPLOYEE_SPOUSE = "EMPLOYEE_SPOUSE"
    EMPLOYEE_CHILD = "EMPLOYEE_CHILD"
    EMPLOYEE_CHILDREN = "EMPLOYEE_CHILDREN"
    EMPLOYEE_FAMILY = "EMPLOYEE_FAMILY"
    FAMILY = "FAMILY"
    OTHER = "OTHER"


class EmployerContributionType(str, Enum, metaclass=utils.OpenEnumMeta):
    PERCENTAGE = "PERCENTAGE"
    FIXED = "FIXED"


class HrisBenefitFrequency(str, Enum, metaclass=utils.OpenEnumMeta):
    ONE_TIME = "ONE_TIME"
    DAY = "DAY"
    QUARTER = "QUARTER"
    YEAR = "YEAR"
    HOUR = "HOUR"
    MONTH = "MONTH"
    WEEK = "WEEK"


class Tax(str, Enum, metaclass=utils.OpenEnumMeta):
    PRE_TAX = "PRE_TAX"
    POST_TAX = "POST_TAX"
    TAXABLE = "TAXABLE"
    NON_TAXABLE = "NON_TAXABLE"
    TAX = "TAX"


class HrisBenefitType(str, Enum, metaclass=utils.OpenEnumMeta):
    RETIREMENT = "RETIREMENT"
    HEALTH = "HEALTH"
    DENTAL = "DENTAL"
    VISION = "VISION"
    LIFE = "LIFE"
    HSA = "HSA"
    FSA = "FSA"
    SHORT_TERM_DISABILITY = "SHORT_TERM_DISABILITY"
    LONG_TERM_DISABILITY = "LONG_TERM_DISABILITY"
    WORKERS_COMP = "WORKERS_COMP"
    HOUSING_STIPEND = "HOUSING_STIPEND"
    EMPLOYER_TAX_CONTRIBUTION = "EMPLOYER_TAX_CONTRIBUTION"
    GARNISHMENT = "GARNISHMENT"
    LOAN_REPAYMENT = "LOAN_REPAYMENT"
    CHARITABLE_CONTRIBUTION = "CHARITABLE_CONTRIBUTION"
    OTHER = "OTHER"


class HrisBenefitTypedDict(TypedDict):
    r"""Company-wide benefit plans available to employees."""

    company_id: NotRequired[str]
    coverage_level: NotRequired[CoverageLevel]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    description: NotRequired[str]
    employer_contribution_amount: NotRequired[float]
    employer_contribution_max_amount: NotRequired[float]
    employer_contribution_type: NotRequired[EmployerContributionType]
    frequency: NotRequired[HrisBenefitFrequency]
    id: NotRequired[str]
    is_active: NotRequired[bool]
    name: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    tax: NotRequired[Tax]
    type: NotRequired[HrisBenefitType]
    updated_at: NotRequired[datetime]


class HrisBenefit(BaseModel):
    r"""Company-wide benefit plans available to employees."""

    company_id: Optional[str] = None

    coverage_level: Annotated[
        Optional[CoverageLevel], PlainValidator(validate_open_enum(False))
    ] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    description: Optional[str] = None

    employer_contribution_amount: Optional[float] = None

    employer_contribution_max_amount: Optional[float] = None

    employer_contribution_type: Annotated[
        Optional[EmployerContributionType], PlainValidator(validate_open_enum(False))
    ] = None

    frequency: Annotated[
        Optional[HrisBenefitFrequency], PlainValidator(validate_open_enum(False))
    ] = None

    id: Optional[str] = None

    is_active: Optional[bool] = None

    name: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    tax: Annotated[Optional[Tax], PlainValidator(validate_open_enum(False))] = None

    type: Annotated[
        Optional[HrisBenefitType], PlainValidator(validate_open_enum(False))
    ] = None

    updated_at: Optional[datetime] = None

    @field_serializer("coverage_level")
    def serialize_coverage_level(self, value):
        if isinstance(value, str):
            try:
                return shared.CoverageLevel(value)
            except ValueError:
                return value
        return value

    @field_serializer("employer_contribution_type")
    def serialize_employer_contribution_type(self, value):
        if isinstance(value, str):
            try:
                return shared.EmployerContributionType(value)
            except ValueError:
                return value
        return value

    @field_serializer("frequency")
    def serialize_frequency(self, value):
        if isinstance(value, str):
            try:
                return shared.HrisBenefitFrequency(value)
            except ValueError:
                return value
        return value

    @field_serializer("tax")
    def serialize_tax(self, value):
        if isinstance(value, str):
            try:
                return shared.Tax(value)
            except ValueError:
                return value
        return value

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.HrisBenefitType(value)
            except ValueError:
                return value
        return value
