"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class HrisMetadata1TypedDict(TypedDict):
    pass


class HrisMetadata1(BaseModel):
    pass


HrisMetadata5TypedDict = TypeAliasType(
    "HrisMetadata5TypedDict", Union[HrisMetadata1TypedDict, str, float, bool]
)


HrisMetadata5 = TypeAliasType("HrisMetadata5", Union[HrisMetadata1, str, float, bool])


HrisMetadataExtraDataTypedDict = TypeAliasType(
    "HrisMetadataExtraDataTypedDict",
    Union[Dict[str, Any], str, float, bool, List[HrisMetadata5TypedDict]],
)


HrisMetadataExtraData = TypeAliasType(
    "HrisMetadataExtraData",
    Union[Dict[str, Any], str, float, bool, List[HrisMetadata5]],
)


class HrisMetadataFormat(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    BOOLEAN = "BOOLEAN"
    FILE = "FILE"
    TEXTAREA = "TEXTAREA"
    SINGLE_SELECT = "SINGLE_SELECT"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    MEASUREMENT = "MEASUREMENT"
    PRICE = "PRICE"
    YES_NO = "YES_NO"
    CURRENCY = "CURRENCY"
    URL = "URL"


class HrisMetadataSchemas1TypedDict(TypedDict):
    pass


class HrisMetadataSchemas1(BaseModel):
    pass


HrisMetadataSchemas5TypedDict = TypeAliasType(
    "HrisMetadataSchemas5TypedDict",
    Union[HrisMetadataSchemas1TypedDict, str, float, bool],
)


HrisMetadataSchemas5 = TypeAliasType(
    "HrisMetadataSchemas5", Union[HrisMetadataSchemas1, str, float, bool]
)


HrisMetadataValueTypedDict = TypeAliasType(
    "HrisMetadataValueTypedDict",
    Union[Dict[str, Any], str, float, bool, List[HrisMetadataSchemas5TypedDict]],
)


HrisMetadataValue = TypeAliasType(
    "HrisMetadataValue",
    Union[Dict[str, Any], str, float, bool, List[HrisMetadataSchemas5]],
)


class HrisMetadataTypedDict(TypedDict):
    extra_data: NotRequired[HrisMetadataExtraDataTypedDict]
    format_: NotRequired[HrisMetadataFormat]
    id: NotRequired[str]
    key: NotRequired[str]
    namespace: NotRequired[str]
    slug: NotRequired[str]
    type: NotRequired[str]
    value: NotRequired[HrisMetadataValueTypedDict]


class HrisMetadata(BaseModel):
    extra_data: Optional[HrisMetadataExtraData] = None

    format_: Annotated[
        Annotated[
            Optional[HrisMetadataFormat], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="format"),
    ] = None

    id: Optional[str] = None

    key: Optional[str] = None

    namespace: Optional[str] = None

    slug: Optional[str] = None

    type: Optional[str] = None

    value: Optional[HrisMetadataValue] = None

    @field_serializer("format_")
    def serialize_format_(self, value):
        if isinstance(value, str):
            try:
                return shared.HrisMetadataFormat(value)
            except ValueError:
                return value
        return value
