"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .hrispayslipdetail import HrisPayslipDetail, HrisPayslipDetailTypedDict
from .property_hrispayslip_deduction import (
    PropertyHrisPayslipDeduction,
    PropertyHrisPayslipDeductionTypedDict,
)
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class PaymentType(str, Enum, metaclass=utils.OpenEnumMeta):
    DIRECT = "DIRECT"
    CHEQUE = "CHEQUE"
    CASH = "CASH"


class HrisPayslipTypedDict(TypedDict):
    raw: Dict[str, Any]
    company_id: NotRequired[str]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    deduction: NotRequired[PropertyHrisPayslipDeductionTypedDict]
    r"""// The ID (and optionally name) of the employee deduction (if this detail represents a deduction)"""
    details: NotRequired[List[HrisPayslipDetailTypedDict]]
    end_at: NotRequired[datetime]
    gross_amount: NotRequired[float]
    id: NotRequired[str]
    net_amount: NotRequired[float]
    paid_at: NotRequired[datetime]
    payment_type: NotRequired[PaymentType]
    start_at: NotRequired[datetime]
    updated_at: NotRequired[datetime]
    user_id: NotRequired[str]


class HrisPayslip(BaseModel):
    raw: Dict[str, Any]

    company_id: Optional[str] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    deduction: Optional[PropertyHrisPayslipDeduction] = None
    r"""// The ID (and optionally name) of the employee deduction (if this detail represents a deduction)"""

    details: Optional[List[HrisPayslipDetail]] = None

    end_at: Optional[datetime] = None

    gross_amount: Optional[float] = None

    id: Optional[str] = None

    net_amount: Optional[float] = None

    paid_at: Optional[datetime] = None

    payment_type: Annotated[
        Optional[PaymentType], PlainValidator(validate_open_enum(False))
    ] = None

    start_at: Optional[datetime] = None

    updated_at: Optional[datetime] = None

    user_id: Optional[str] = None

    @field_serializer("payment_type")
    def serialize_payment_type(self, value):
        if isinstance(value, str):
            try:
                return shared.PaymentType(value)
            except ValueError:
                return value
        return value
