"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .integrationsupport import IntegrationSupport, IntegrationSupportTypedDict
from .property_integration_categories import PropertyIntegrationCategories
from datetime import datetime
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class Integration1TypedDict(TypedDict):
    pass


class Integration1(BaseModel):
    pass


Integration5TypedDict = TypeAliasType(
    "Integration5TypedDict", Union[Integration1TypedDict, str, float, bool]
)


Integration5 = TypeAliasType("Integration5", Union[Integration1, str, float, bool])


APITypedDict = TypeAliasType(
    "APITypedDict", Union[Dict[str, Any], str, float, bool, List[Integration5TypedDict]]
)


API = TypeAliasType("API", Union[Dict[str, Any], str, float, bool, List[Integration5]])


class IntegrationSchemas1TypedDict(TypedDict):
    pass


class IntegrationSchemas1(BaseModel):
    pass


IntegrationSchemas5TypedDict = TypeAliasType(
    "IntegrationSchemas5TypedDict",
    Union[IntegrationSchemas1TypedDict, str, float, bool],
)


IntegrationSchemas5 = TypeAliasType(
    "IntegrationSchemas5", Union[IntegrationSchemas1, str, float, bool]
)


PartnershipTypedDict = TypeAliasType(
    "PartnershipTypedDict",
    Union[Dict[str, Any], str, float, bool, List[IntegrationSchemas5TypedDict]],
)


Partnership = TypeAliasType(
    "Partnership", Union[Dict[str, Any], str, float, bool, List[IntegrationSchemas5]]
)


class IntegrationSchemasSaml1TypedDict(TypedDict):
    pass


class IntegrationSchemasSaml1(BaseModel):
    pass


IntegrationSchemasSaml5TypedDict = TypeAliasType(
    "IntegrationSchemasSaml5TypedDict",
    Union[IntegrationSchemasSaml1TypedDict, str, float, bool],
)


IntegrationSchemasSaml5 = TypeAliasType(
    "IntegrationSchemasSaml5", Union[IntegrationSchemasSaml1, str, float, bool]
)


SamlTypedDict = TypeAliasType(
    "SamlTypedDict",
    Union[Dict[str, Any], str, float, bool, List[IntegrationSchemasSaml5TypedDict]],
)


Saml = TypeAliasType(
    "Saml", Union[Dict[str, Any], str, float, bool, List[IntegrationSchemasSaml5]]
)


class IntegrationSchemasSandbox1TypedDict(TypedDict):
    pass


class IntegrationSchemasSandbox1(BaseModel):
    pass


IntegrationSchemasSandbox5TypedDict = TypeAliasType(
    "IntegrationSchemasSandbox5TypedDict",
    Union[IntegrationSchemasSandbox1TypedDict, str, float, bool],
)


IntegrationSchemasSandbox5 = TypeAliasType(
    "IntegrationSchemasSandbox5", Union[IntegrationSchemasSandbox1, str, float, bool]
)


SandboxTypedDict = TypeAliasType(
    "SandboxTypedDict",
    Union[Dict[str, Any], str, float, bool, List[IntegrationSchemasSandbox5TypedDict]],
)


Sandbox = TypeAliasType(
    "Sandbox", Union[Dict[str, Any], str, float, bool, List[IntegrationSchemasSandbox5]]
)


class IntegrationTypedDict(TypedDict):
    r"""Informational object for supported integrations."""

    categories: List[PropertyIntegrationCategories]
    r"""The categories of support solutions that this integration has"""
    name: str
    type: str
    active_healthy_connections: NotRequired[float]
    api: NotRequired[APITypedDict]
    api_docs_url: NotRequired[str]
    beta: NotRequired[bool]
    color: NotRequired[str]
    created_at: NotRequired[str]
    description: NotRequired[str]
    fa_icon: NotRequired[str]
    featured: NotRequired[bool]
    in_progress: NotRequired[bool]
    is_active: NotRequired[bool]
    logo_url: NotRequired[str]
    partnership: NotRequired[PartnershipTypedDict]
    popularity: NotRequired[float]
    rate_limit_description: NotRequired[str]
    saml: NotRequired[SamlTypedDict]
    sandbox: NotRequired[SandboxTypedDict]
    support: NotRequired[Dict[str, IntegrationSupportTypedDict]]
    tested_at: NotRequired[datetime]
    text_color: NotRequired[str]
    token_instructions: NotRequired[List[str]]
    r"""instructions for the user on how to find the token/key"""
    token_names: NotRequired[List[str]]
    r"""if auth_types = 'token'"""
    updated_at: NotRequired[str]
    web_url: NotRequired[str]


class Integration(BaseModel):
    r"""Informational object for supported integrations."""

    categories: List[
        Annotated[
            PropertyIntegrationCategories, PlainValidator(validate_open_enum(False))
        ]
    ]
    r"""The categories of support solutions that this integration has"""

    name: str

    type: str

    active_healthy_connections: Optional[float] = None

    api: Optional[API] = None

    api_docs_url: Optional[str] = None

    beta: Optional[bool] = None

    color: Optional[str] = None

    created_at: Optional[str] = None

    description: Optional[str] = None

    fa_icon: Optional[str] = None

    featured: Optional[bool] = None

    in_progress: Optional[bool] = None

    is_active: Optional[bool] = None

    logo_url: Optional[str] = None

    partnership: Optional[Partnership] = None

    popularity: Optional[float] = None

    rate_limit_description: Optional[str] = None

    saml: Optional[Saml] = None

    sandbox: Optional[Sandbox] = None

    support: Optional[Dict[str, IntegrationSupport]] = None

    tested_at: Optional[datetime] = None

    text_color: Optional[str] = None

    token_instructions: Optional[List[str]] = None
    r"""instructions for the user on how to find the token/key"""

    token_names: Optional[List[str]] = None
    r"""if auth_types = 'token'"""

    updated_at: Optional[str] = None

    web_url: Optional[str] = None
