"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .kmspagemetadata import KmsPageMetadata, KmsPageMetadataTypedDict
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class KmsPageType(str, Enum, metaclass=utils.OpenEnumMeta):
    HTML = "HTML"
    MARKDOWN = "MARKDOWN"
    TEXT = "TEXT"
    OTHER = "OTHER"


class KmsPageTypedDict(TypedDict):
    title: str
    type: KmsPageType
    created_at: NotRequired[datetime]
    download_url: NotRequired[str]
    has_children: NotRequired[bool]
    id: NotRequired[str]
    is_active: NotRequired[bool]
    metadata: NotRequired[List[KmsPageMetadataTypedDict]]
    parent_id: NotRequired[str]
    parent_page_id: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    space_id: NotRequired[str]
    updated_at: NotRequired[datetime]
    user_id: NotRequired[str]
    web_url: NotRequired[str]


class KmsPage(BaseModel):
    title: str

    type: Annotated[KmsPageType, PlainValidator(validate_open_enum(False))]

    created_at: Optional[datetime] = None

    download_url: Optional[str] = None

    has_children: Optional[bool] = None

    id: Optional[str] = None

    is_active: Optional[bool] = None

    metadata: Optional[List[KmsPageMetadata]] = None

    parent_id: Optional[str] = None

    parent_page_id: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    space_id: Optional[str] = None

    updated_at: Optional[datetime] = None

    user_id: Optional[str] = None

    web_url: Optional[str] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.KmsPageType(value)
            except ValueError:
                return value
        return value
