"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class KmsPageMetadata1TypedDict(TypedDict):
    pass


class KmsPageMetadata1(BaseModel):
    pass


KmsPageMetadata5TypedDict = TypeAliasType(
    "KmsPageMetadata5TypedDict", Union[KmsPageMetadata1TypedDict, str, float, bool]
)


KmsPageMetadata5 = TypeAliasType(
    "KmsPageMetadata5", Union[KmsPageMetadata1, str, float, bool]
)


KmsPageMetadataExtraDataTypedDict = TypeAliasType(
    "KmsPageMetadataExtraDataTypedDict",
    Union[Dict[str, Any], str, float, bool, List[KmsPageMetadata5TypedDict]],
)


KmsPageMetadataExtraData = TypeAliasType(
    "KmsPageMetadataExtraData",
    Union[Dict[str, Any], str, float, bool, List[KmsPageMetadata5]],
)


class KmsPageMetadataFormat(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    BOOLEAN = "BOOLEAN"
    FILE = "FILE"
    TEXTAREA = "TEXTAREA"
    SINGLE_SELECT = "SINGLE_SELECT"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    MEASUREMENT = "MEASUREMENT"
    PRICE = "PRICE"
    YES_NO = "YES_NO"
    CURRENCY = "CURRENCY"
    URL = "URL"
    PERCENT = "PERCENT"
    EMAIL = "EMAIL"
    PHONE = "PHONE"
    REFERENCE = "REFERENCE"
    TIME = "TIME"


class KmsPageMetadataSchemas1TypedDict(TypedDict):
    pass


class KmsPageMetadataSchemas1(BaseModel):
    pass


KmsPageMetadataSchemas5TypedDict = TypeAliasType(
    "KmsPageMetadataSchemas5TypedDict",
    Union[KmsPageMetadataSchemas1TypedDict, str, float, bool],
)


KmsPageMetadataSchemas5 = TypeAliasType(
    "KmsPageMetadataSchemas5", Union[KmsPageMetadataSchemas1, str, float, bool]
)


KmsPageMetadataValueTypedDict = TypeAliasType(
    "KmsPageMetadataValueTypedDict",
    Union[Dict[str, Any], str, float, bool, List[KmsPageMetadataSchemas5TypedDict]],
)


KmsPageMetadataValue = TypeAliasType(
    "KmsPageMetadataValue",
    Union[Dict[str, Any], str, float, bool, List[KmsPageMetadataSchemas5]],
)


class KmsPageMetadataTypedDict(TypedDict):
    extra_data: NotRequired[KmsPageMetadataExtraDataTypedDict]
    format_: NotRequired[KmsPageMetadataFormat]
    id: NotRequired[str]
    key: NotRequired[str]
    namespace: NotRequired[str]
    slug: NotRequired[str]
    type: NotRequired[str]
    value: NotRequired[KmsPageMetadataValueTypedDict]


class KmsPageMetadata(BaseModel):
    extra_data: Optional[KmsPageMetadataExtraData] = None

    format_: Annotated[
        Annotated[
            Optional[KmsPageMetadataFormat], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="format"),
    ] = None

    id: Optional[str] = None

    key: Optional[str] = None

    namespace: Optional[str] = None

    slug: Optional[str] = None

    type: Optional[str] = None

    value: Optional[KmsPageMetadataValue] = None

    @field_serializer("format_")
    def serialize_format_(self, value):
        if isinstance(value, str):
            try:
                return shared.KmsPageMetadataFormat(value)
            except ValueError:
                return value
        return value
