"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class LmsMediaType(str, Enum, metaclass=utils.OpenEnumMeta):
    IMAGE = "IMAGE"
    HEADSHOT = "HEADSHOT"
    VIDEO = "VIDEO"
    WEB = "WEB"
    DOCUMENT = "DOCUMENT"
    OTHER = "OTHER"


class LmsMediaTypedDict(TypedDict):
    url: str
    description: NotRequired[str]
    name: NotRequired[str]
    thumbnail_url: NotRequired[str]
    type: NotRequired[LmsMediaType]


class LmsMedia(BaseModel):
    url: str

    description: Optional[str] = None

    name: Optional[str] = None

    thumbnail_url: Optional[str] = None

    type: Annotated[
        Optional[LmsMediaType], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.LmsMediaType(value)
            except ValueError:
                return value
        return value
