"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class MetadataMetadataFormat(str, Enum, metaclass=utils.OpenEnumMeta):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    BOOLEAN = "BOOLEAN"
    FILE = "FILE"
    TEXTAREA = "TEXTAREA"
    SINGLE_SELECT = "SINGLE_SELECT"
    MULTIPLE_SELECT = "MULTIPLE_SELECT"
    MEASUREMENT = "MEASUREMENT"
    PRICE = "PRICE"
    YES_NO = "YES_NO"
    CURRENCY = "CURRENCY"
    URL = "URL"


class MetadataMetadataTypedDict(TypedDict):
    name: str
    object_type: str
    created_at: NotRequired[datetime]
    format_: NotRequired[MetadataMetadataFormat]
    id: NotRequired[str]
    objects: NotRequired[Dict[str, Any]]
    options: NotRequired[List[str]]
    original_format: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    slug: NotRequired[str]
    updated_at: NotRequired[datetime]


class MetadataMetadata(BaseModel):
    name: str

    object_type: str

    created_at: Optional[datetime] = None

    format_: Annotated[
        Annotated[
            Optional[MetadataMetadataFormat], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="format"),
    ] = None

    id: Optional[str] = None

    objects: Optional[Dict[str, Any]] = None

    options: Optional[List[str]] = None

    original_format: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    slug: Optional[str] = None

    updated_at: Optional[datetime] = None

    @field_serializer("format_")
    def serialize_format_(self, value):
        if isinstance(value, str):
            try:
                return shared.MetadataMetadataFormat(value)
            except ValueError:
                return value
        return value
