"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class PaymentPayoutStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    SUCCEEDED = "SUCCEEDED"
    PENDING = "PENDING"
    FAILED = "FAILED"
    CANCELED = "CANCELED"


class PaymentPayoutTypedDict(TypedDict):
    total_amount: float
    created_at: NotRequired[str]
    currency: NotRequired[str]
    id: NotRequired[str]
    notes: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    status: NotRequired[PaymentPayoutStatus]
    updated_at: NotRequired[str]


class PaymentPayout(BaseModel):
    total_amount: float

    created_at: Optional[str] = None

    currency: Optional[str] = None

    id: Optional[str] = None

    notes: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    status: Annotated[
        Optional[PaymentPayoutStatus], PlainValidator(validate_open_enum(False))
    ] = None

    updated_at: Optional[str] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.PaymentPayoutStatus(value)
            except ValueError:
                return value
        return value
