"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class PropertyCalendarEventOrganizerStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    ACCEPTED = "ACCEPTED"
    REJECTED = "REJECTED"
    TENTATIVE = "TENTATIVE"


class PropertyCalendarEventOrganizerTypedDict(TypedDict):
    email: NotRequired[str]
    name: NotRequired[str]
    required: NotRequired[bool]
    status: NotRequired[PropertyCalendarEventOrganizerStatus]
    user_id: NotRequired[str]


class PropertyCalendarEventOrganizer(BaseModel):
    email: Optional[str] = None

    name: Optional[str] = None

    required: Optional[bool] = None

    status: Annotated[
        Optional[PropertyCalendarEventOrganizerStatus],
        PlainValidator(validate_open_enum(False)),
    ] = None

    user_id: Optional[str] = None

    @field_serializer("status")
    def serialize_status(self, value):
        if isinstance(value, str):
            try:
                return shared.PropertyCalendarEventOrganizerStatus(value)
            except ValueError:
                return value
        return value
