"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class PropertyHrisPayslipDeductionCoverageLevel(
    str, Enum, metaclass=utils.OpenEnumMeta
):
    EMPLOYEE_ONLY = "EMPLOYEE_ONLY"
    EMPLOYEE_SPOUSE = "EMPLOYEE_SPOUSE"
    EMPLOYEE_CHILD = "EMPLOYEE_CHILD"
    EMPLOYEE_CHILDREN = "EMPLOYEE_CHILDREN"
    EMPLOYEE_FAMILY = "EMPLOYEE_FAMILY"
    FAMILY = "FAMILY"
    OTHER = "OTHER"


class PropertyHrisPayslipDeductionFrequency(str, Enum, metaclass=utils.OpenEnumMeta):
    ONE_TIME = "ONE_TIME"
    DAY = "DAY"
    QUARTER = "QUARTER"
    YEAR = "YEAR"
    HOUR = "HOUR"
    MONTH = "MONTH"
    WEEK = "WEEK"


class PropertyHrisPayslipDeductionType(str, Enum, metaclass=utils.OpenEnumMeta):
    FIXED = "FIXED"
    PERCENTAGE = "PERCENTAGE"


class PropertyHrisPayslipDeductionTypedDict(TypedDict):
    r"""// The ID (and optionally name) of the employee deduction (if this detail represents a deduction)"""

    amount: NotRequired[float]
    benefit_id: NotRequired[str]
    company_id: NotRequired[str]
    coverage_level: NotRequired[PropertyHrisPayslipDeductionCoverageLevel]
    created_at: NotRequired[datetime]
    end_at: NotRequired[datetime]
    frequency: NotRequired[PropertyHrisPayslipDeductionFrequency]
    id: NotRequired[str]
    is_active: NotRequired[bool]
    raw: NotRequired[Dict[str, Any]]
    start_at: NotRequired[datetime]
    type: NotRequired[PropertyHrisPayslipDeductionType]
    updated_at: NotRequired[datetime]
    user_id: NotRequired[str]


class PropertyHrisPayslipDeduction(BaseModel):
    r"""// The ID (and optionally name) of the employee deduction (if this detail represents a deduction)"""

    amount: Optional[float] = None

    benefit_id: Optional[str] = None

    company_id: Optional[str] = None

    coverage_level: Annotated[
        Optional[PropertyHrisPayslipDeductionCoverageLevel],
        PlainValidator(validate_open_enum(False)),
    ] = None

    created_at: Optional[datetime] = None

    end_at: Optional[datetime] = None

    frequency: Annotated[
        Optional[PropertyHrisPayslipDeductionFrequency],
        PlainValidator(validate_open_enum(False)),
    ] = None

    id: Optional[str] = None

    is_active: Optional[bool] = None

    raw: Optional[Dict[str, Any]] = None

    start_at: Optional[datetime] = None

    type: Annotated[
        Optional[PropertyHrisPayslipDeductionType],
        PlainValidator(validate_open_enum(False)),
    ] = None

    updated_at: Optional[datetime] = None

    user_id: Optional[str] = None

    @field_serializer("coverage_level")
    def serialize_coverage_level(self, value):
        if isinstance(value, str):
            try:
                return shared.PropertyHrisPayslipDeductionCoverageLevel(value)
            except ValueError:
                return value
        return value

    @field_serializer("frequency")
    def serialize_frequency(self, value):
        if isinstance(value, str):
            try:
                return shared.PropertyHrisPayslipDeductionFrequency(value)
            except ValueError:
                return value
        return value

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.PropertyHrisPayslipDeductionType(value)
            except ValueError:
                return value
        return value
