"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class Ethnicity(str, Enum, metaclass=utils.OpenEnumMeta):
    CAUCASIAN = "Caucasian"
    EAST_ASIAN = "East Asian"
    MIDDLE_EASTERN = "Middle Eastern"
    BLACK = "Black"
    BIRACIAL_SOUTH_ASIAN_AND_CAUCASIAN_ = "Biracial (South Asian & Caucasian)"
    FILIPINO = "Filipino"
    SOUTH_ASIAN = "South Asian"
    INDIAN = "Indian"
    WHITE = "White"
    ASIAN = "Asian"


class PropertyScimUserUrnIetfParamsScimSchemasExtensionLatticeAttributes10UserGender(
    str, Enum, metaclass=utils.OpenEnumMeta
):
    MALE = "male"
    FEMALE = "female"


class SexualOrientation(str, Enum, metaclass=utils.OpenEnumMeta):
    QUEER = "Queer"
    HETEROSEXUAL = "Heterosexual"
    STRAIGHT = "Straight"


class PropertyScimUserUrnIetfParamsScimSchemasExtensionLatticeAttributes10UserTypedDict(
    TypedDict
):
    job_level: NotRequired[str]
    people_manager_reviews: NotRequired[str]
    remote_work_location: NotRequired[str]
    salary_information: NotRequired[str]
    sub_departments: NotRequired[str]
    birth_date: NotRequired[datetime]
    ethnicity: NotRequired[Ethnicity]
    gender: NotRequired[
        PropertyScimUserUrnIetfParamsScimSchemasExtensionLatticeAttributes10UserGender
    ]
    sexual_orientation: NotRequired[SexualOrientation]
    start_date: NotRequired[datetime]


class PropertyScimUserUrnIetfParamsScimSchemasExtensionLatticeAttributes10User(
    BaseModel
):
    job_level: Annotated[Optional[str], pydantic.Field(alias="Job Level")] = None

    people_manager_reviews: Annotated[
        Optional[str], pydantic.Field(alias="People Manager (Reviews)")
    ] = None

    remote_work_location: Annotated[
        Optional[str], pydantic.Field(alias="Remote Work - Location")
    ] = None

    salary_information: Annotated[
        Optional[str], pydantic.Field(alias="Salary Information")
    ] = None

    sub_departments: Annotated[
        Optional[str], pydantic.Field(alias="Sub Departments")
    ] = None

    birth_date: Annotated[Optional[datetime], pydantic.Field(alias="birthDate")] = None

    ethnicity: Annotated[
        Optional[Ethnicity], PlainValidator(validate_open_enum(False))
    ] = None

    gender: Annotated[
        Optional[
            PropertyScimUserUrnIetfParamsScimSchemasExtensionLatticeAttributes10UserGender
        ],
        PlainValidator(validate_open_enum(False)),
    ] = None

    sexual_orientation: Annotated[
        Annotated[
            Optional[SexualOrientation], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="sexualOrientation"),
    ] = None

    start_date: Annotated[Optional[datetime], pydantic.Field(alias="startDate")] = None

    @field_serializer("ethnicity")
    def serialize_ethnicity(self, value):
        if isinstance(value, str):
            try:
                return shared.Ethnicity(value)
            except ValueError:
                return value
        return value

    @field_serializer("gender")
    def serialize_gender(self, value):
        if isinstance(value, str):
            try:
                return shared.PropertyScimUserUrnIetfParamsScimSchemasExtensionLatticeAttributes10UserGender(
                    value
                )
            except ValueError:
                return value
        return value

    @field_serializer("sexual_orientation")
    def serialize_sexual_orientation(self, value):
        if isinstance(value, str):
            try:
                return shared.SexualOrientation(value)
            except ValueError:
                return value
        return value
