"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class ScimEmailType(str, Enum, metaclass=utils.OpenEnumMeta):
    WORK = "work"
    HOME = "home"
    OTHER = "other"


class ScimEmailTypedDict(TypedDict):
    type: ScimEmailType
    display: NotRequired[str]
    primary: NotRequired[bool]
    value: NotRequired[str]


class ScimEmail(BaseModel):
    type: Annotated[ScimEmailType, PlainValidator(validate_open_enum(False))]

    display: Optional[str] = None

    primary: Optional[bool] = None

    value: Optional[str] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.ScimEmailType(value)
            except ValueError:
                return value
        return value
