"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class Operation(str, Enum, metaclass=utils.OpenEnumMeta):
    ADD = "add"
    DELETE = "delete"


class ScimGroupMemberType(str, Enum, metaclass=utils.OpenEnumMeta):
    USER = "User"
    GROUP = "Group"


class ScimGroupMemberTypedDict(TypedDict):
    value: str
    dollar_ref: NotRequired[str]
    display: NotRequired[str]
    operation: NotRequired[Operation]
    type: NotRequired[ScimGroupMemberType]


class ScimGroupMember(BaseModel):
    value: str

    dollar_ref: Annotated[Optional[str], pydantic.Field(alias="$ref")] = None

    display: Optional[str] = None

    operation: Annotated[
        Optional[Operation], PlainValidator(validate_open_enum(False))
    ] = None

    type: Annotated[
        Optional[ScimGroupMemberType], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("operation")
    def serialize_operation(self, value):
        if isinstance(value, str):
            try:
                return shared.Operation(value)
            except ValueError:
                return value
        return value

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.ScimGroupMemberType(value)
            except ValueError:
                return value
        return value
