"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class ScimPhotoType(str, Enum, metaclass=utils.OpenEnumMeta):
    PHOTO = "photo"
    THUMBNAIL = "thumbnail"


class ScimPhotoTypedDict(TypedDict):
    display: NotRequired[str]
    primary: NotRequired[bool]
    type: NotRequired[ScimPhotoType]
    value: NotRequired[str]


class ScimPhoto(BaseModel):
    display: Optional[str] = None

    primary: Optional[bool] = None

    type: Annotated[
        Optional[ScimPhotoType], PlainValidator(validate_open_enum(False))
    ] = None

    value: Optional[str] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.ScimPhotoType(value)
            except ValueError:
                return value
        return value
