"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class ScimUserGroupsType(str, Enum, metaclass=utils.OpenEnumMeta):
    DIRECT = "direct"
    INDIRECT = "indirect"


class ScimUserGroupsTypedDict(TypedDict):
    value: str
    dollar_ref: NotRequired[str]
    display: NotRequired[str]
    type: NotRequired[ScimUserGroupsType]


class ScimUserGroups(BaseModel):
    value: str

    dollar_ref: Annotated[Optional[str], pydantic.Field(alias="$ref")] = None

    display: Optional[str] = None

    type: Annotated[
        Optional[ScimUserGroupsType], PlainValidator(validate_open_enum(False))
    ] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.ScimUserGroupsType(value)
            except ValueError:
                return value
        return value
