"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .verificationparameter import VerificationParameter, VerificationParameterTypedDict
from .verificationtime import VerificationTime, VerificationTimeTypedDict
from datetime import datetime
from enum import Enum
from pydantic import field_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.models import shared
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class VerificationPackageType(str, Enum, metaclass=utils.OpenEnumMeta):
    IDENTITY_VERIFICATION = "IDENTITY_VERIFICATION"
    SCREENING = "SCREENING"
    BACKGROUND_CHECK = "BACKGROUND_CHECK"
    EMPLOYMENT_VERIFICATION = "EMPLOYMENT_VERIFICATION"
    EDUCATION_VERIFICATION = "EDUCATION_VERIFICATION"
    CREDIT_CHECK = "CREDIT_CHECK"
    FRAUD_PREVENTION = "FRAUD_PREVENTION"
    OTHER = "OTHER"


class VerificationPackageTypedDict(TypedDict):
    id: str
    name: str
    type: VerificationPackageType
    aliases: NotRequired[List[str]]
    average_processing_times: NotRequired[List[VerificationTimeTypedDict]]
    r"""average processing time in minutes"""
    cost_amount: NotRequired[float]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    description: NotRequired[str]
    has_redirect_url: NotRequired[bool]
    has_target_url: NotRequired[bool]
    info_url: NotRequired[str]
    max_score: NotRequired[float]
    needs_ip_address: NotRequired[bool]
    parameters: NotRequired[List[VerificationParameterTypedDict]]
    r"""Questions that need to be answered for this verification"""
    raw: NotRequired[Dict[str, Any]]
    tags: NotRequired[List[str]]
    r"""Category (Verification, Validation, Background Check)"""
    updated_at: NotRequired[datetime]


class VerificationPackage(BaseModel):
    id: str

    name: str

    type: Annotated[VerificationPackageType, PlainValidator(validate_open_enum(False))]

    aliases: Optional[List[str]] = None

    average_processing_times: Optional[List[VerificationTime]] = None
    r"""average processing time in minutes"""

    cost_amount: Optional[float] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    description: Optional[str] = None

    has_redirect_url: Optional[bool] = None

    has_target_url: Optional[bool] = None

    info_url: Optional[str] = None

    max_score: Optional[float] = None

    needs_ip_address: Optional[bool] = None

    parameters: Optional[List[VerificationParameter]] = None
    r"""Questions that need to be answered for this verification"""

    raw: Optional[Dict[str, Any]] = None

    tags: Optional[List[str]] = None
    r"""Category (Verification, Validation, Background Check)"""

    updated_at: Optional[datetime] = None

    @field_serializer("type")
    def serialize_type(self, value):
        if isinstance(value, str):
            try:
                return shared.VerificationPackageType(value)
            except ValueError:
                return value
        return value
