"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
import httpx
import importlib
import sys
from typing import Callable, Dict, Optional, TYPE_CHECKING, Union, cast
from unified_python_sdk import utils
from unified_python_sdk._hooks import SDKHooks
from unified_python_sdk.models import shared
from unified_python_sdk.types import OptionalNullable, UNSET
import weakref

if TYPE_CHECKING:
    from unified_python_sdk.account import Account
    from unified_python_sdk.accounting import Accounting
    from unified_python_sdk.activity import Activity
    from unified_python_sdk.apicall import Apicall
    from unified_python_sdk.application import Application
    from unified_python_sdk.applicationstatus import Applicationstatus
    from unified_python_sdk.ats import Ats
    from unified_python_sdk.auth import Auth
    from unified_python_sdk.balancesheet import Balancesheet
    from unified_python_sdk.benefit import Benefit
    from unified_python_sdk.bill import Bill
    from unified_python_sdk.branch import Branch
    from unified_python_sdk.busy import Busy
    from unified_python_sdk.calendar import Calendar
    from unified_python_sdk.call import Call
    from unified_python_sdk.candidate import Candidate
    from unified_python_sdk.cashflow import Cashflow
    from unified_python_sdk.category import Category
    from unified_python_sdk.change import Change
    from unified_python_sdk.channel import Channel
    from unified_python_sdk.class_ import Class
    from unified_python_sdk.collection import Collection
    from unified_python_sdk.comment import Comment
    from unified_python_sdk.commerce import Commerce
    from unified_python_sdk.commit import Commit
    from unified_python_sdk.company import Company
    from unified_python_sdk.connection import Connection
    from unified_python_sdk.contact import Contact
    from unified_python_sdk.course import Course
    from unified_python_sdk.creditmemo import Creditmemo
    from unified_python_sdk.crm import Crm
    from unified_python_sdk.customer import Customer
    from unified_python_sdk.deal import Deal
    from unified_python_sdk.deduction import Deduction
    from unified_python_sdk.device import Device
    from unified_python_sdk.document import Document
    from unified_python_sdk.embedding import Embedding
    from unified_python_sdk.employee import Employee
    from unified_python_sdk.enrich import Enrich
    from unified_python_sdk.environment import Environment
    from unified_python_sdk.event import Event
    from unified_python_sdk.expense import Expense
    from unified_python_sdk.file import File
    from unified_python_sdk.genai import Genai
    from unified_python_sdk.group import Group
    from unified_python_sdk.hris import Hris
    from unified_python_sdk.instructor import Instructor
    from unified_python_sdk.integration import Integration
    from unified_python_sdk.interview import Interview
    from unified_python_sdk.inventory import Inventory
    from unified_python_sdk.invoice import Invoice
    from unified_python_sdk.issue import Issue
    from unified_python_sdk.item import Item
    from unified_python_sdk.job import Job
    from unified_python_sdk.journal import Journal
    from unified_python_sdk.kms import Kms
    from unified_python_sdk.lead import Lead
    from unified_python_sdk.link import Link
    from unified_python_sdk.list import ListT
    from unified_python_sdk.lms import Lms
    from unified_python_sdk.location import Location
    from unified_python_sdk.login import Login
    from unified_python_sdk.martech import Martech
    from unified_python_sdk.member import Member
    from unified_python_sdk.message import Message
    from unified_python_sdk.messaging import Messaging
    from unified_python_sdk.metadata import Metadata
    from unified_python_sdk.model import Model
    from unified_python_sdk.note import Note
    from unified_python_sdk.order import Order
    from unified_python_sdk.organization import Organization
    from unified_python_sdk.package import Package
    from unified_python_sdk.page import Page
    from unified_python_sdk.passthrough import Passthrough
    from unified_python_sdk.payment import Payment
    from unified_python_sdk.payout import Payout
    from unified_python_sdk.payslip import Payslip
    from unified_python_sdk.person import Person
    from unified_python_sdk.pipeline import Pipeline
    from unified_python_sdk.profitloss import Profitloss
    from unified_python_sdk.project import Project
    from unified_python_sdk.prompt import Prompt
    from unified_python_sdk.pullrequest import Pullrequest
    from unified_python_sdk.purchaseorder import Purchaseorder
    from unified_python_sdk.recording import Recording
    from unified_python_sdk.refund import Refund
    from unified_python_sdk.repo import Repo
    from unified_python_sdk.report import Report
    from unified_python_sdk.repository import Repository
    from unified_python_sdk.request import Request
    from unified_python_sdk.review import Review
    from unified_python_sdk.saleschannel import Saleschannel
    from unified_python_sdk.salesorder import Salesorder
    from unified_python_sdk.scim import Scim
    from unified_python_sdk.scorecard import Scorecard
    from unified_python_sdk.space import Space
    from unified_python_sdk.storage import Storage
    from unified_python_sdk.student import Student
    from unified_python_sdk.subscription import Subscription
    from unified_python_sdk.task import Task
    from unified_python_sdk.taxrate import Taxrate
    from unified_python_sdk.ticket import Ticket
    from unified_python_sdk.ticketing import Ticketing
    from unified_python_sdk.timeoff import Timeoff
    from unified_python_sdk.timeshift import Timeshift
    from unified_python_sdk.transaction import Transaction
    from unified_python_sdk.trialbalance import Trialbalance
    from unified_python_sdk.uc import Uc
    from unified_python_sdk.unified import Unified
    from unified_python_sdk.user import User
    from unified_python_sdk.verification import Verification
    from unified_python_sdk.webhook import Webhook


class UnifiedTo(BaseSDK):
    r"""Unified.to API: One API to Rule Them All"""

    accounting: "Accounting"
    account: "Account"
    balancesheet: "Balancesheet"
    bill: "Bill"
    cashflow: "Cashflow"
    category: "Category"
    contact: "Contact"
    creditmemo: "Creditmemo"
    expense: "Expense"
    invoice: "Invoice"
    journal: "Journal"
    order: "Order"
    organization: "Organization"
    profitloss: "Profitloss"
    purchaseorder: "Purchaseorder"
    report: "Report"
    salesorder: "Salesorder"
    taxrate: "Taxrate"
    transaction: "Transaction"
    trialbalance: "Trialbalance"
    ats: "Ats"
    activity: "Activity"
    application: "Application"
    applicationstatus: "Applicationstatus"
    candidate: "Candidate"
    company: "Company"
    document: "Document"
    interview: "Interview"
    job: "Job"
    scorecard: "Scorecard"
    calendar: "Calendar"
    busy: "Busy"
    event: "Event"
    link: "Link"
    recording: "Recording"
    commerce: "Commerce"
    collection: "Collection"
    inventory: "Inventory"
    item: "Item"
    location: "Location"
    review: "Review"
    saleschannel: "Saleschannel"
    crm: "Crm"
    deal: "Deal"
    lead: "Lead"
    pipeline: "Pipeline"
    enrich: "Enrich"
    person: "Person"
    genai: "Genai"
    embedding: "Embedding"
    model: "Model"
    prompt: "Prompt"
    hris: "Hris"
    benefit: "Benefit"
    deduction: "Deduction"
    device: "Device"
    employee: "Employee"
    group: "Group"
    payslip: "Payslip"
    timeoff: "Timeoff"
    timeshift: "Timeshift"
    kms: "Kms"
    comment: "Comment"
    page: "Page"
    space: "Space"
    lms: "Lms"
    class_: "Class"
    course: "Course"
    instructor: "Instructor"
    student: "Student"
    martech: "Martech"
    list: "ListT"
    member: "Member"
    messaging: "Messaging"
    channel: "Channel"
    message: "Message"
    metadata: "Metadata"
    passthrough: "Passthrough"
    payment: "Payment"
    payout: "Payout"
    refund: "Refund"
    subscription: "Subscription"
    repo: "Repo"
    branch: "Branch"
    commit: "Commit"
    pullrequest: "Pullrequest"
    repository: "Repository"
    scim: "Scim"
    user: "User"
    storage: "Storage"
    file: "File"
    task: "Task"
    change: "Change"
    project: "Project"
    ticketing: "Ticketing"
    customer: "Customer"
    note: "Note"
    ticket: "Ticket"
    uc: "Uc"
    call: "Call"
    unified: "Unified"
    apicall: "Apicall"
    connection: "Connection"
    environment: "Environment"
    integration: "Integration"
    auth: "Auth"
    login: "Login"
    issue: "Issue"
    webhook: "Webhook"
    verification: "Verification"
    package: "Package"
    request: "Request"
    _sub_sdk_map = {
        "accounting": ("unified_python_sdk.accounting", "Accounting"),
        "account": ("unified_python_sdk.account", "Account"),
        "balancesheet": ("unified_python_sdk.balancesheet", "Balancesheet"),
        "bill": ("unified_python_sdk.bill", "Bill"),
        "cashflow": ("unified_python_sdk.cashflow", "Cashflow"),
        "category": ("unified_python_sdk.category", "Category"),
        "contact": ("unified_python_sdk.contact", "Contact"),
        "creditmemo": ("unified_python_sdk.creditmemo", "Creditmemo"),
        "expense": ("unified_python_sdk.expense", "Expense"),
        "invoice": ("unified_python_sdk.invoice", "Invoice"),
        "journal": ("unified_python_sdk.journal", "Journal"),
        "order": ("unified_python_sdk.order", "Order"),
        "organization": ("unified_python_sdk.organization", "Organization"),
        "profitloss": ("unified_python_sdk.profitloss", "Profitloss"),
        "purchaseorder": ("unified_python_sdk.purchaseorder", "Purchaseorder"),
        "report": ("unified_python_sdk.report", "Report"),
        "salesorder": ("unified_python_sdk.salesorder", "Salesorder"),
        "taxrate": ("unified_python_sdk.taxrate", "Taxrate"),
        "transaction": ("unified_python_sdk.transaction", "Transaction"),
        "trialbalance": ("unified_python_sdk.trialbalance", "Trialbalance"),
        "ats": ("unified_python_sdk.ats", "Ats"),
        "activity": ("unified_python_sdk.activity", "Activity"),
        "application": ("unified_python_sdk.application", "Application"),
        "applicationstatus": (
            "unified_python_sdk.applicationstatus",
            "Applicationstatus",
        ),
        "candidate": ("unified_python_sdk.candidate", "Candidate"),
        "company": ("unified_python_sdk.company", "Company"),
        "document": ("unified_python_sdk.document", "Document"),
        "interview": ("unified_python_sdk.interview", "Interview"),
        "job": ("unified_python_sdk.job", "Job"),
        "scorecard": ("unified_python_sdk.scorecard", "Scorecard"),
        "calendar": ("unified_python_sdk.calendar", "Calendar"),
        "busy": ("unified_python_sdk.busy", "Busy"),
        "event": ("unified_python_sdk.event", "Event"),
        "link": ("unified_python_sdk.link", "Link"),
        "recording": ("unified_python_sdk.recording", "Recording"),
        "commerce": ("unified_python_sdk.commerce", "Commerce"),
        "collection": ("unified_python_sdk.collection", "Collection"),
        "inventory": ("unified_python_sdk.inventory", "Inventory"),
        "item": ("unified_python_sdk.item", "Item"),
        "location": ("unified_python_sdk.location", "Location"),
        "review": ("unified_python_sdk.review", "Review"),
        "saleschannel": ("unified_python_sdk.saleschannel", "Saleschannel"),
        "crm": ("unified_python_sdk.crm", "Crm"),
        "deal": ("unified_python_sdk.deal", "Deal"),
        "lead": ("unified_python_sdk.lead", "Lead"),
        "pipeline": ("unified_python_sdk.pipeline", "Pipeline"),
        "enrich": ("unified_python_sdk.enrich", "Enrich"),
        "person": ("unified_python_sdk.person", "Person"),
        "genai": ("unified_python_sdk.genai", "Genai"),
        "embedding": ("unified_python_sdk.embedding", "Embedding"),
        "model": ("unified_python_sdk.model", "Model"),
        "prompt": ("unified_python_sdk.prompt", "Prompt"),
        "hris": ("unified_python_sdk.hris", "Hris"),
        "benefit": ("unified_python_sdk.benefit", "Benefit"),
        "deduction": ("unified_python_sdk.deduction", "Deduction"),
        "device": ("unified_python_sdk.device", "Device"),
        "employee": ("unified_python_sdk.employee", "Employee"),
        "group": ("unified_python_sdk.group", "Group"),
        "payslip": ("unified_python_sdk.payslip", "Payslip"),
        "timeoff": ("unified_python_sdk.timeoff", "Timeoff"),
        "timeshift": ("unified_python_sdk.timeshift", "Timeshift"),
        "kms": ("unified_python_sdk.kms", "Kms"),
        "comment": ("unified_python_sdk.comment", "Comment"),
        "page": ("unified_python_sdk.page", "Page"),
        "space": ("unified_python_sdk.space", "Space"),
        "lms": ("unified_python_sdk.lms", "Lms"),
        "class_": ("unified_python_sdk.class_", "Class"),
        "course": ("unified_python_sdk.course", "Course"),
        "instructor": ("unified_python_sdk.instructor", "Instructor"),
        "student": ("unified_python_sdk.student", "Student"),
        "martech": ("unified_python_sdk.martech", "Martech"),
        "list": ("unified_python_sdk.list", "ListT"),
        "member": ("unified_python_sdk.member", "Member"),
        "messaging": ("unified_python_sdk.messaging", "Messaging"),
        "channel": ("unified_python_sdk.channel", "Channel"),
        "message": ("unified_python_sdk.message", "Message"),
        "metadata": ("unified_python_sdk.metadata", "Metadata"),
        "passthrough": ("unified_python_sdk.passthrough", "Passthrough"),
        "payment": ("unified_python_sdk.payment", "Payment"),
        "payout": ("unified_python_sdk.payout", "Payout"),
        "refund": ("unified_python_sdk.refund", "Refund"),
        "subscription": ("unified_python_sdk.subscription", "Subscription"),
        "repo": ("unified_python_sdk.repo", "Repo"),
        "branch": ("unified_python_sdk.branch", "Branch"),
        "commit": ("unified_python_sdk.commit", "Commit"),
        "pullrequest": ("unified_python_sdk.pullrequest", "Pullrequest"),
        "repository": ("unified_python_sdk.repository", "Repository"),
        "scim": ("unified_python_sdk.scim", "Scim"),
        "user": ("unified_python_sdk.user", "User"),
        "storage": ("unified_python_sdk.storage", "Storage"),
        "file": ("unified_python_sdk.file", "File"),
        "task": ("unified_python_sdk.task", "Task"),
        "change": ("unified_python_sdk.change", "Change"),
        "project": ("unified_python_sdk.project", "Project"),
        "ticketing": ("unified_python_sdk.ticketing", "Ticketing"),
        "customer": ("unified_python_sdk.customer", "Customer"),
        "note": ("unified_python_sdk.note", "Note"),
        "ticket": ("unified_python_sdk.ticket", "Ticket"),
        "uc": ("unified_python_sdk.uc", "Uc"),
        "call": ("unified_python_sdk.call", "Call"),
        "unified": ("unified_python_sdk.unified", "Unified"),
        "apicall": ("unified_python_sdk.apicall", "Apicall"),
        "connection": ("unified_python_sdk.connection", "Connection"),
        "environment": ("unified_python_sdk.environment", "Environment"),
        "integration": ("unified_python_sdk.integration", "Integration"),
        "auth": ("unified_python_sdk.auth", "Auth"),
        "login": ("unified_python_sdk.login", "Login"),
        "issue": ("unified_python_sdk.issue", "Issue"),
        "webhook": ("unified_python_sdk.webhook", "Webhook"),
        "verification": ("unified_python_sdk.verification", "Verification"),
        "package": ("unified_python_sdk.package", "Package"),
        "request": ("unified_python_sdk.request", "Request"),
    }

    def __init__(
        self,
        security: Union[shared.Security, Callable[[], shared.Security]],
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client(follow_redirects=True)
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient(follow_redirects=True)
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        current_server_url, *_ = self.sdk_configuration.get_server_details()
        server_url, self.sdk_configuration.client = hooks.sdk_init(
            current_server_url, client
        )
        if current_server_url != server_url:
            self.sdk_configuration.server_url = server_url

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def dynamic_import(self, modname, retries=3):
        for attempt in range(retries):
            try:
                return importlib.import_module(modname)
            except KeyError:
                # Clear any half-initialized module and retry
                sys.modules.pop(modname, None)
                if attempt == retries - 1:
                    break
        raise KeyError(f"Failed to import module '{modname}' after {retries} attempts")

    def __getattr__(self, name: str):
        if name in self._sub_sdk_map:
            module_path, class_name = self._sub_sdk_map[name]
            try:
                module = self.dynamic_import(module_path)
                klass = getattr(module, class_name)
                instance = klass(self.sdk_configuration, parent_ref=self)
                setattr(self, name, instance)
                return instance
            except ImportError as e:
                raise AttributeError(
                    f"Failed to import module {module_path} for attribute {name}: {e}"
                ) from e
            except AttributeError as e:
                raise AttributeError(
                    f"Failed to find class {class_name} in module {module_path} for attribute {name}: {e}"
                ) from e

        raise AttributeError(
            f"'{type(self).__name__}' object has no attribute '{name}'"
        )

    def __dir__(self):
        default_attrs = list(super().__dir__())
        lazy_attrs = list(self._sub_sdk_map.keys())
        return sorted(list(set(default_attrs + lazy_attrs)))

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None
