"""Assets2 Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.assets2.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.assets2 import Assets2Service

log = logging.getLogger(__name__)


class TaegisSDKAssets2Query:
    """Teagis Assets2 Query operations."""

    def __init__(self, service: Assets2Service):
        self.service = service

    def facets_v2(self, endpoint_type: List[EndpointTypeV2]) -> List[FacetV2]:
        """Retrieve a list of facets for a given endpoint type.."""
        endpoint = "facetsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "endpointType": prepare_input(endpoint_type),
            },
            output=build_output_string(FacetV2),
        )
        if result.get(endpoint) is not None:
            return FacetV2.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query facetsV2")

    def facet_info_v2(
        self,
        facets: List[str],
        order_by: Optional[FacetInfoOrderByInputV2] = None,
        filter_: Optional[AssetFilter] = None,
    ) -> List[FacetInfoV2]:
        """Get facet info based on a currently selected facet.."""
        endpoint = "facetInfoV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "facets": prepare_input(facets),
                "orderBy": prepare_input(order_by),
                "filter": prepare_input(filter_),
            },
            output=build_output_string(FacetInfoV2),
        )
        if result.get(endpoint) is not None:
            return FacetInfoV2.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query facetInfoV2")

    def assets_v2(
        self,
        first: Optional[int] = None,
        last: Optional[int] = None,
        after: Optional[str] = None,
        before: Optional[str] = None,
        filter_: Optional[AssetFilter] = None,
        order_by: Optional[AssetSearchOrderByInputV2] = None,
    ) -> AssetsV2:
        """Retrieve assets.."""
        endpoint = "assetsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "first": prepare_input(first),
                "last": prepare_input(last),
                "after": prepare_input(after),
                "before": prepare_input(before),
                "filter": prepare_input(filter_),
                "orderBy": prepare_input(order_by),
            },
            output=build_output_string(AssetsV2),
        )
        if result.get(endpoint) is not None:
            return AssetsV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query assetsV2")

    def export_assets_v2(
        self,
        first: Optional[int] = None,
        after: Optional[str] = None,
        filter_: Optional[AssetFilter] = None,
        order_by: Optional[AssetSearchOrderByInputV2] = None,
    ) -> AssetsExportOutputV2:
        """Retrieve assets in a form coercible into CSV files.."""
        endpoint = "exportAssetsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "first": prepare_input(first),
                "after": prepare_input(after),
                "filter": prepare_input(filter_),
                "orderBy": prepare_input(order_by),
            },
            output=build_output_string(AssetsExportOutputV2),
        )
        if result.get(endpoint) is not None:
            return AssetsExportOutputV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query exportAssetsV2")

    def tag_keys_v2(self, filter_: Optional[TagFilter] = None) -> List[str]:
        """Fetch the tag keys matching the filter criteria.."""
        endpoint = "tagKeysV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filter": prepare_input(filter_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query tagKeysV2")

    def tag_values_v2(self, filter_: Optional[TagFilter] = None) -> List[str]:
        """Fetch the tag values matching the filter criteria.."""
        endpoint = "tagValuesV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filter": prepare_input(filter_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query tagValuesV2")

    def update_tags_for_endpoint_status_v2(self, id_: str) -> TaskInfoPayload:
        """Return the status of the updateTagsForEndpointV2 operation.."""
        endpoint = "updateTagsForEndpointStatusV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query updateTagsForEndpointStatusV2")

    def delete_assets_status_v2(self, id_: str) -> TaskInfoPayload:
        """Return the status of the deleteAssetsV2 operation.."""
        endpoint = "deleteAssetsStatusV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query deleteAssetsStatusV2")

    def restore_assets_status_v2(self, id_: str) -> TaskInfoPayload:
        """Return the status of the restoreAssetsV2 operation.."""
        endpoint = "restoreAssetsStatusV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query restoreAssetsStatusV2")

    def assign_bulk_assets_to_group_status(self, id_: str) -> TaskInfoPayload:
        """Return the status of the assignBulkAssetsToGroup operation.."""
        endpoint = "assignBulkAssetsToGroupStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query assignBulkAssetsToGroupStatus")

    def bulk_update_tags_for_endpoints_status_v2(self, id_: str) -> TaskInfoPayload:
        """Return the status of the bulkUpdateTagsForEndpointsV2 operation.."""
        endpoint = "bulkUpdateTagsForEndpointsStatusV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query bulkUpdateTagsForEndpointsStatusV2"
        )

    def bulk_delete_tags_for_endpoints_status_v2(self, id_: str) -> TaskInfoPayload:
        """Return the status of the bulkDeleteTagsForEndpointsV2 operation.."""
        endpoint = "bulkDeleteTagsForEndpointsStatusV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query bulkDeleteTagsForEndpointsStatusV2"
        )

    def assign_bulk_assets_to_investigation_status(self, id_: str) -> TaskInfoPayload:
        """Return the status of the assignBulkAssetsToInvestigation operation.."""
        endpoint = "assignBulkAssetsToInvestigationStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query assignBulkAssetsToInvestigationStatus"
        )

    def bulk_delete_investigation_for_endpoints_status(
        self, id_: str
    ) -> TaskInfoPayload:
        """Return the status of the bulkDeleteInvestigationForEndpoints operation.."""
        endpoint = "bulkDeleteInvestigationForEndpointsStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query bulkDeleteInvestigationForEndpointsStatus"
        )

    def bulk_reconnect_native_assets_status(self, id_: str) -> TaskInfoPayload:
        """Return the status of the bulkReconnectNativeAssets operation.."""
        endpoint = "bulkReconnectNativeAssetsStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query bulkReconnectNativeAssetsStatus")

    def bulk_uninstall_native_assets_status(self, id_: str) -> TaskInfoPayload:
        """Return the status of the bulkUninstallNativeAssets operation.."""
        endpoint = "bulkUninstallNativeAssetsStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TaskInfoPayload),
        )
        if result.get(endpoint) is not None:
            return TaskInfoPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query bulkUninstallNativeAssetsStatus")

    def asset_dead_period(self) -> str:
        """Return the tenant's asset dead period threshold used by the api. The value
        from the tenants preference api is used if present, otherwise the default of
        720h (30 days) is used.."""
        endpoint = "assetDeadPeriod"

        result = self.service.execute_query(endpoint=endpoint, variables={}, output="")
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query assetDeadPeriod")

    def subject_can_isolate(self) -> CanIsolateResponse:
        """Returns whether a subject can isolate an asset for the current tenant context."""
        endpoint = "subjectCanIsolate"

        result = self.service.execute_query(endpoint=endpoint, variables={}, output="")
        if result.get(endpoint) is not None:
            return CanIsolateResponse(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query subjectCanIsolate")
