"""EntityProfile Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.entity_profile.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.entity_profile import EntityProfileService

log = logging.getLogger(__name__)


class TaegisSDKEntityProfileQuery:
    """Teagis Entity_profile Query operations."""

    def __init__(self, service: EntityProfileService):
        self.service = service

    def get_auth_attempts_timeline(
        self,
        start_time_millis: str,
        end_time_millis: str,
        source_ip: Optional[str] = None,
        target_user_name: Optional[str] = None,
    ) -> AuthAttemptsTimeline:
        """None."""
        endpoint = "getAuthAttemptsTimeline"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "sourceIP": prepare_input(source_ip),
                "targetUserName": prepare_input(target_user_name),
                "startTimeMillis": prepare_input(start_time_millis),
                "endTimeMillis": prepare_input(end_time_millis),
            },
            output=build_output_string(AuthAttemptsTimeline),
        )
        if result.get(endpoint) is not None:
            return AuthAttemptsTimeline.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query getAuthAttemptsTimeline")
