"""Investigations2 Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class AlertResolutionStatus(str, Enum):
    """AlertResolutionStatus."""

    OPEN = "OPEN"
    TRUE_POSITIVE_BENIGN = "TRUE_POSITIVE_BENIGN"
    TRUE_POSITIVE_MALICIOUS = "TRUE_POSITIVE_MALICIOUS"
    FALSE_POSITIVE = "FALSE_POSITIVE"
    NOT_ACTIONABLE = "NOT_ACTIONABLE"
    OTHER = "OTHER"
    SUPPRESSED = "SUPPRESSED"


class InvestigationRuleState(str, Enum):
    """InvestigationRuleState."""

    ENABLED = "ENABLED"
    APPEND = "APPEND"
    DISABLED = "DISABLED"
    TEST = "TEST"


class InvestigationStatus(str, Enum):
    """InvestigationStatus."""

    DRAFT = "DRAFT"
    DRAFT_DISMISSED = "DRAFT_DISMISSED"
    OPEN = "OPEN"
    AWAITING_ACTION = "AWAITING_ACTION"
    ACTIVE = "ACTIVE"
    SUSPENDED = "SUSPENDED"
    CLOSED_CONFIRMED_SECURITY_INCIDENT = "CLOSED_CONFIRMED_SECURITY_INCIDENT"
    CLOSED_AUTHORIZED_ACTIVITY = "CLOSED_AUTHORIZED_ACTIVITY"
    CLOSED_THREAT_MITIGATED = "CLOSED_THREAT_MITIGATED"
    CLOSED_NOT_VULNERABLE = "CLOSED_NOT_VULNERABLE"
    CLOSED_FALSE_POSITIVE_ALERT = "CLOSED_FALSE_POSITIVE_ALERT"
    CLOSED_INCONCLUSIVE = "CLOSED_INCONCLUSIVE"
    CLOSED_INFORMATIONAL = "CLOSED_INFORMATIONAL"


class InvestigationCloseStatus(str, Enum):
    """InvestigationCloseStatus."""

    CLOSED_CONFIRMED_SECURITY_INCIDENT = "CLOSED_CONFIRMED_SECURITY_INCIDENT"
    CLOSED_AUTHORIZED_ACTIVITY = "CLOSED_AUTHORIZED_ACTIVITY"
    CLOSED_THREAT_MITIGATED = "CLOSED_THREAT_MITIGATED"
    CLOSED_NOT_VULNERABLE = "CLOSED_NOT_VULNERABLE"
    CLOSED_FALSE_POSITIVE_ALERT = "CLOSED_FALSE_POSITIVE_ALERT"
    CLOSED_INCONCLUSIVE = "CLOSED_INCONCLUSIVE"
    CLOSED_INFORMATIONAL = "CLOSED_INFORMATIONAL"


class InvestigationType(str, Enum):
    """InvestigationType."""

    SECURITY_INVESTIGATION = "SECURITY_INVESTIGATION"
    INCIDENT_RESPONSE = "INCIDENT_RESPONSE"
    THREAT_HUNT = "THREAT_HUNT"
    MANAGED_XDR_THREAT_HUNT = "MANAGED_XDR_THREAT_HUNT"
    CTU_THREAT_HUNT = "CTU_THREAT_HUNT"
    MANAGED_XDR_ELITE_THREAT_HUNT = "MANAGED_XDR_ELITE_THREAT_HUNT"
    SECUREWORKS_INCIDENT_RESPONSE = "SECUREWORKS_INCIDENT_RESPONSE"


class InvestigationProcessingState(str, Enum):
    """InvestigationProcessingState."""

    SUCCESS = "SUCCESS"
    FAILED = "FAILED"
    RUNNING = "RUNNING"


class InvestigationResourceType(str, Enum):
    """InvestigationResourceType."""

    INVESTIGATION_TEMPLATE = "INVESTIGATION_TEMPLATE"
    INVESTIGATION_RULE = "INVESTIGATION_RULE"


class PaginationOrder(str, Enum):
    """PaginationOrder."""

    ASCENDING = "ASCENDING"
    DESCENDING = "DESCENDING"


class InvestigationV2TimelineEntityType(str, Enum):
    """InvestigationV2TimelineEntityType."""

    ALERT = "ALERT"
    EVENT = "EVENT"
    AUDIT = "AUDIT"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddEvidenceToInvestigationInput:
    """AddEvidenceToInvestigationInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    alerts_search_query: Optional[str] = field(
        default=None, metadata=config(field_name="alertsSearchQuery")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RemoveEvidenceFromInvestigationInput:
    """RemoveEvidenceFromInvestigationInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    assets: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assets")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationRuleInput:
    """DeleteInvestigationRuleInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ArchiveInvestigationInput:
    """ArchiveInvestigationInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddEvidenceToInvestigationResult:
    """AddEvidenceToInvestigationResult."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    alerts_search_query: Optional[str] = field(
        default=None, metadata=config(field_name="alertsSearchQuery")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RemoveEvidenceFromInvestigationResult:
    """RemoveEvidenceFromInvestigationResult."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    assets: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assets")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateInvestigationTemplateInput:
    """CreateInvestigationTemplateInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    investigation_type: Optional[str] = field(
        default=None, metadata=config(field_name="investigationType")
    )
    investigation_priority: Optional[str] = field(
        default=None, metadata=config(field_name="investigationPriority")
    )
    investigation_title: Optional[str] = field(
        default=None, metadata=config(field_name="investigationTitle")
    )
    investigation_tags: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationTags")
    )
    investigation_key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="investigationKeyFindings")
    )
    investigation_key_findings_prompts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationKeyFindingsPrompts")
    )
    investigation_assignee: Optional[str] = field(
        default=None, metadata=config(field_name="investigationAssignee")
    )
    investigation_status: Optional[str] = field(
        default=None, metadata=config(field_name="investigationStatus")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationTemplateInput:
    """UpdateInvestigationTemplateInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    investigation_type: Optional[str] = field(
        default=None, metadata=config(field_name="investigationType")
    )
    investigation_priority: Optional[str] = field(
        default=None, metadata=config(field_name="investigationPriority")
    )
    investigation_title: Optional[str] = field(
        default=None, metadata=config(field_name="investigationTitle")
    )
    investigation_tags: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationTags")
    )
    investigation_key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="investigationKeyFindings")
    )
    investigation_key_findings_prompts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationKeyFindingsPrompts")
    )
    investigation_assignee: Optional[str] = field(
        default=None, metadata=config(field_name="investigationAssignee")
    )
    investigation_status: Optional[str] = field(
        default=None, metadata=config(field_name="investigationStatus")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationTemplateInput:
    """DeleteInvestigationTemplateInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Arguments:
    """InvestigationV2Arguments."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplateArguments:
    """InvestigationTemplateArguments."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplatesArguments:
    """InvestigationTemplatesArguments."""

    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    name: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="name",
        ),
    )
    tags: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="tags",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRuleArguments:
    """InvestigationRuleArguments."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRulesArguments:
    """InvestigationRulesArguments."""

    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    name: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="name",
        ),
    )
    tags: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "no-op; use cql"},
            field_name="tags",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExportInvestigationResourceInput:
    """ExportInvestigationResourceInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ImportInvestigationResourcesInput:
    """ImportInvestigationResourcesInput."""

    file: Optional[str] = field(default=None, metadata=config(field_name="file"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationResourceExport:
    """InvestigationResourceExport."""

    export: Optional[str] = field(default=None, metadata=config(field_name="export"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddCommentToInvestigationInput:
    """AddCommentToInvestigationInput."""

    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationCommentInput:
    """UpdateInvestigationCommentInput."""

    comment_id: Optional[str] = field(
        default=None, metadata=config(field_name="commentId")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    mark_as_read: Optional[bool] = field(
        default=None, metadata=config(field_name="markAsRead")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteInvestigationCommentInput:
    """DeleteInvestigationCommentInput."""

    comment_id: Optional[str] = field(
        default=None, metadata=config(field_name="commentId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationCommentsCount:
    """InvestigationCommentsCount."""

    total: Optional[int] = field(default=None, metadata=config(field_name="total"))
    unread: Optional[int] = field(default=None, metadata=config(field_name="unread"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertEvidence:
    """AlertEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    alert_id: Optional[str] = field(default=None, metadata=config(field_name="alertId"))
    is_genesis: Optional[bool] = field(
        default=None, metadata=config(field_name="isGenesis")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EventEvidence:
    """EventEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    event_id: Optional[str] = field(default=None, metadata=config(field_name="eventId"))
    is_genesis: Optional[bool] = field(
        default=None, metadata=config(field_name="isGenesis")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssetEvidence:
    """AssetEvidence."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    asset_id: Optional[str] = field(default=None, metadata=config(field_name="assetId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TDRUser:
    """TDRUser."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateInvestigationRuleInput:
    """CreateInvestigationRuleInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    filter: Optional[str] = field(default=None, metadata=config(field_name="filter"))
    append_filter: Optional[str] = field(
        default=None, metadata=config(field_name="appendFilter")
    )
    append_comment: Optional[str] = field(
        default=None, metadata=config(field_name="appendComment")
    )
    group_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupBy")
    )
    group_count: Optional[int] = field(
        default=None, metadata=config(field_name="groupCount")
    )
    group_duration: Optional[str] = field(
        default=None, metadata=config(field_name="groupDuration")
    )
    group_extend_on_append: Optional[bool] = field(
        default=None, metadata=config(field_name="groupExtendOnAppend")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    search_window: Optional[str] = field(
        default=None, metadata=config(field_name="searchWindow")
    )
    tenant_filter: Optional[str] = field(
        default=None, metadata=config(field_name="tenantFilter")
    )
    template_id: Optional[str] = field(
        default=None, metadata=config(field_name="templateId")
    )
    response_data: Optional[dict] = field(
        default=None, metadata=config(field_name="responseData")
    )
    state: Optional[InvestigationRuleState] = field(
        default=None, metadata=config(field_name="state")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationRuleInput:
    """UpdateInvestigationRuleInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    filter: Optional[str] = field(default=None, metadata=config(field_name="filter"))
    append_filter: Optional[str] = field(
        default=None, metadata=config(field_name="appendFilter")
    )
    append_comment: Optional[str] = field(
        default=None, metadata=config(field_name="appendComment")
    )
    group_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupBy")
    )
    group_count: Optional[int] = field(
        default=None, metadata=config(field_name="groupCount")
    )
    group_duration: Optional[str] = field(
        default=None, metadata=config(field_name="groupDuration")
    )
    group_extend_on_append: Optional[bool] = field(
        default=None, metadata=config(field_name="groupExtendOnAppend")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    search_window: Optional[str] = field(
        default=None, metadata=config(field_name="searchWindow")
    )
    tenant_filter: Optional[str] = field(
        default=None, metadata=config(field_name="tenantFilter")
    )
    template_id: Optional[str] = field(
        default=None, metadata=config(field_name="templateId")
    )
    response_data: Optional[dict] = field(
        default=None, metadata=config(field_name="responseData")
    )
    state: Optional[InvestigationRuleState] = field(
        default=None, metadata=config(field_name="state")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationsV2Arguments:
    """InvestigationsV2Arguments."""

    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    cql: Optional[str] = field(default=None, metadata=config(field_name="cql"))
    search_children_tenants: Optional[bool] = field(
        default=None, metadata=config(field_name="searchChildrenTenants")
    )
    order_by: Optional[PaginationOrder] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "does not do anything - sorting is done through cql",
            },
            field_name="orderBy",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExportInvestigationResourcesArgument:
    """ExportInvestigationResourcesArgument."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    type: Optional[InvestigationResourceType] = field(
        default=None, metadata=config(field_name="type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2TimelineEntity:
    """InvestigationV2TimelineEntity."""

    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="entityId")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    descriptor: Optional[str] = field(
        default=None, metadata=config(field_name="descriptor")
    )
    user_id: Optional[str] = field(default=None, metadata=config(field_name="userId"))
    user: Optional[TDRUser] = field(default=None, metadata=config(field_name="user"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentsV2Arguments:
    """CommentsV2Arguments."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    order_by: Optional[PaginationOrder] = field(
        default=None, metadata=config(field_name="orderBy")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Type:
    """InvestigationV2Type."""

    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    type: Optional[InvestigationType] = field(
        default=None, metadata=config(field_name="type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateInvestigationInput:
    """CreateInvestigationInput."""

    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="keyFindings")
    )
    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    service_desk_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskId")
    )
    service_desk_type: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskType")
    )
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleId"))
    template_id: Optional[str] = field(
        default=None, metadata=config(field_name="templateId")
    )
    type: Optional[InvestigationType] = field(
        default=None, metadata=config(field_name="type")
    )
    status: Optional[InvestigationStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationV2Input:
    """UpdateInvestigationV2Input."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="keyFindings")
    )
    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    service_desk_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskId")
    )
    service_desk_type: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskType")
    )
    type: Optional[InvestigationType] = field(
        default=None, metadata=config(field_name="type")
    )
    status: Optional[InvestigationStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CloseInvestigationInput:
    """CloseInvestigationInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    status: Optional[InvestigationCloseStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    alerts_resolution_status: Optional[AlertResolutionStatus] = field(
        default=None, metadata=config(field_name="alertsResolutionStatus")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplate:
    """InvestigationTemplate."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="createdById")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="updatedById")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    investigation_type: Optional[str] = field(
        default=None, metadata=config(field_name="investigationType")
    )
    investigation_priority: Optional[str] = field(
        default=None, metadata=config(field_name="investigationPriority")
    )
    investigation_title: Optional[str] = field(
        default=None, metadata=config(field_name="investigationTitle")
    )
    investigation_tags: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationTags")
    )
    investigation_key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="investigationKeyFindings")
    )
    investigation_key_findings_prompts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationKeyFindingsPrompts")
    )
    investigation_assignee: Optional[str] = field(
        default=None, metadata=config(field_name="investigationAssignee")
    )
    investigation_status: Optional[str] = field(
        default=None, metadata=config(field_name="investigationStatus")
    )
    created_by: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    updated_by: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="updatedBy")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2TimelineArguments:
    """InvestigationV2TimelineArguments."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    created_after: Optional[str] = field(
        default=None, metadata=config(field_name="createdAfter")
    )
    created_before: Optional[str] = field(
        default=None, metadata=config(field_name="createdBefore")
    )
    order_by: Optional[PaginationOrder] = field(
        default=None, metadata=config(field_name="orderBy")
    )
    entity_types: Optional[List[InvestigationV2TimelineEntityType]] = field(
        default=None, metadata=config(field_name="entityTypes")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationProcessingStatus:
    """InvestigationProcessingStatus."""

    assets: Optional[InvestigationProcessingState] = field(
        default=None, metadata=config(field_name="assets")
    )
    events: Optional[InvestigationProcessingState] = field(
        default=None, metadata=config(field_name="events")
    )
    alerts: Optional[InvestigationProcessingState] = field(
        default=None, metadata=config(field_name="alerts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentV2:
    """CommentV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    author_id: Optional[str] = field(
        default=None, metadata=config(field_name="authorId")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigationId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    mentions_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mentionsIds")
    )
    read_by_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="readByIds")
    )
    author: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="author")
    )
    mentions_users: Optional[List[TDRUser]] = field(
        default=None, metadata=config(field_name="mentionsUsers")
    )
    read_by: Optional[List[TDRUser]] = field(
        default=None, metadata=config(field_name="readBy")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRule:
    """InvestigationRule."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="createdById")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="updatedById")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    filter: Optional[str] = field(default=None, metadata=config(field_name="filter"))
    append_filter: Optional[str] = field(
        default=None, metadata=config(field_name="appendFilter")
    )
    append_comment: Optional[str] = field(
        default=None, metadata=config(field_name="appendComment")
    )
    group_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupBy")
    )
    group_count: Optional[int] = field(
        default=None, metadata=config(field_name="groupCount")
    )
    group_duration: Optional[str] = field(
        default=None, metadata=config(field_name="groupDuration")
    )
    group_extend_on_append: Optional[bool] = field(
        default=None, metadata=config(field_name="groupExtendOnAppend")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    search_window: Optional[str] = field(
        default=None, metadata=config(field_name="searchWindow")
    )
    tenant_filter: Optional[str] = field(
        default=None, metadata=config(field_name="tenantFilter")
    )
    comment: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use appendComment"},
            field_name="comment",
        ),
    )
    exclude_child_tenants: Optional[bool] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use tenantFilter"},
            field_name="excludeChildTenants",
        ),
    )
    created_by: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    updated_by: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="updatedBy")
    )
    state: Optional[InvestigationRuleState] = field(
        default=None, metadata=config(field_name="state")
    )
    template: Optional[InvestigationTemplate] = field(
        default=None, metadata=config(field_name="template")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2:
    """InvestigationV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    short_id: Optional[str] = field(default=None, metadata=config(field_name="shortId"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    key_findings: Optional[str] = field(
        default=None, metadata=config(field_name="keyFindings")
    )
    alerts: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use alertsEvidence"},
            field_name="alerts",
        ),
    )
    assets: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use assetsEvidence"},
            field_name="assets",
        ),
    )
    events: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use eventsEvidence"},
            field_name="events",
        ),
    )
    alerts_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="alertsEvidenceCount")
    )
    assets_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="assetsEvidenceCount")
    )
    events_evidence_count: Optional[int] = field(
        default=None, metadata=config(field_name="eventsEvidenceCount")
    )
    search_queries: Optional[List[str]] = field(
        default=None, metadata=config(field_name="searchQueries")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    contributor_ids: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use contributorIds"},
            field_name="contributorIDs",
        ),
    )
    contributor_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="contributorIds")
    )
    assignee_id: Optional[str] = field(
        default=None, metadata=config(field_name="assigneeId")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    created_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="createdById")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    updated_by_id: Optional[str] = field(
        default=None, metadata=config(field_name="updatedById")
    )
    archived_at: Optional[str] = field(
        default=None, metadata=config(field_name="archivedAt")
    )
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="priority")
    )
    close_reason: Optional[str] = field(
        default=None, metadata=config(field_name="closeReason")
    )
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleId"))
    service_desk_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskId")
    )
    service_desk_type: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDeskType")
    )
    alerts_evidence: Optional[List[AlertEvidence]] = field(
        default=None, metadata=config(field_name="alertsEvidence")
    )
    assets_evidence: Optional[List[AssetEvidence]] = field(
        default=None, metadata=config(field_name="assetsEvidence")
    )
    events_evidence: Optional[List[EventEvidence]] = field(
        default=None, metadata=config(field_name="eventsEvidence")
    )
    status: Optional[InvestigationStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    contributors: Optional[List[TDRUser]] = field(
        default=None, metadata=config(field_name="contributors")
    )
    assignee: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="assignee")
    )
    created_by: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    updated_by: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="updatedBy")
    )
    type: Optional[InvestigationType] = field(
        default=None, metadata=config(field_name="type")
    )
    processing_status: Optional[InvestigationProcessingStatus] = field(
        default=None, metadata=config(field_name="processingStatus")
    )
    comments_count: Optional[InvestigationCommentsCount] = field(
        default=None, metadata=config(field_name="commentsCount")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationsV2:
    """InvestigationsV2."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    investigations: Optional[List[InvestigationV2]] = field(
        default=None, metadata=config(field_name="investigations")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationTemplates:
    """InvestigationTemplates."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    templates: Optional[List[InvestigationTemplate]] = field(
        default=None, metadata=config(field_name="templates")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ExportInvestigationResourcesArguments:
    """ExportInvestigationResourcesArguments."""

    arguments: Optional[List[ExportInvestigationResourcesArgument]] = field(
        default=None, metadata=config(field_name="arguments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationRules:
    """InvestigationRules."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    rules: Optional[List[InvestigationRule]] = field(
        default=None, metadata=config(field_name="rules")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationV2Timeline:
    """InvestigationV2Timeline."""

    total_entities: Optional[int] = field(
        default=None, metadata=config(field_name="totalEntities")
    )
    entities: Optional[List[InvestigationV2TimelineEntity]] = field(
        default=None, metadata=config(field_name="entities")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentsV2:
    """CommentsV2."""

    comments: Optional[List[CommentV2]] = field(
        default=None, metadata=config(field_name="comments")
    )


InvestigationResource = Union[
    InvestigationTemplate,
    InvestigationRule,
]
