"""Roadrunner Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class ParserType(str, Enum):
    """ParserType."""

    PARENT = "PARENT"
    CHILD = "CHILD"
    STANDALONE = "STANDALONE"


class ParserFormatType(str, Enum):
    """ParserFormatType."""

    CEF = "CEF"
    LEEF = "LEEF"
    JSON = "JSON"
    UNSTRUCTURED = "UNSTRUCTURED"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SyslogSample:
    """SyslogSample."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    collector: Optional[str] = field(
        default=None, metadata=config(field_name="collector")
    )
    service: Optional[str] = field(default=None, metadata=config(field_name="service"))
    source_file: Optional[str] = field(
        default=None, metadata=config(field_name="sourceFile")
    )
    ingest_time: Optional[str] = field(
        default=None, metadata=config(field_name="ingestTime")
    )
    event_time: Optional[str] = field(
        default=None, metadata=config(field_name="eventTime")
    )
    message: Optional[str] = field(default=None, metadata=config(field_name="message"))
    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    sending_host: Optional[str] = field(
        default=None, metadata=config(field_name="sendingHost")
    )
    parsers: Optional[str] = field(default=None, metadata=config(field_name="parsers"))
    key_field: Optional[str] = field(
        default=None, metadata=config(field_name="keyField")
    )
    app_version: Optional[str] = field(
        default=None, metadata=config(field_name="appVersion")
    )
    parser_lib_version: Optional[str] = field(
        default=None, metadata=config(field_name="parserLibVersion")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CountsForSendingHost:
    """CountsForSendingHost."""

    schema_counts: Optional[List[int]] = field(
        default=None, metadata=config(field_name="schemaCounts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SyslogSampleFilter:
    """SyslogSampleFilter."""

    collector: Optional[str] = field(
        default=None, metadata=config(field_name="collector")
    )
    service: Optional[str] = field(default=None, metadata=config(field_name="service"))
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    sending_host: Optional[str] = field(
        default=None, metadata=config(field_name="sendingHost")
    )
    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SyslogMessageCountOptions:
    """SyslogMessageCountOptions."""

    timespan_minutes: Optional[int] = field(
        default=None, metadata=config(field_name="timespanMinutes")
    )
    by_collector: Optional[bool] = field(
        default=None, metadata=config(field_name="byCollector")
    )
    by_service: Optional[bool] = field(
        default=None, metadata=config(field_name="byService")
    )
    by_sensor_type: Optional[bool] = field(
        default=None, metadata=config(field_name="bySensorType")
    )
    by_sending_host: Optional[bool] = field(
        default=None, metadata=config(field_name="bySendingHost")
    )
    by_schema: Optional[bool] = field(
        default=None, metadata=config(field_name="bySchema")
    )
    collector: Optional[str] = field(
        default=None, metadata=config(field_name="collector")
    )
    service: Optional[str] = field(default=None, metadata=config(field_name="service"))
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    sending_host: Optional[str] = field(
        default=None, metadata=config(field_name="sendingHost")
    )
    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Parser:
    """Parser."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    directory_id: Optional[int] = field(
        default=None, metadata=config(field_name="directoryId")
    )
    disabled: Optional[bool] = field(
        default=None, metadata=config(field_name="disabled")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ValidateResult:
    """ValidateResult."""

    ok: Optional[bool] = field(default=None, metadata=config(field_name="ok"))
    message: Optional[str] = field(default=None, metadata=config(field_name="message"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UnvalidatedParserInput:
    """UnvalidatedParserInput."""

    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )
    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdatedParserInput:
    """UpdatedParserInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )
    directory_id: Optional[int] = field(
        default=None, metadata=config(field_name="directoryId")
    )
    disabled: Optional[bool] = field(
        default=None, metadata=config(field_name="disabled")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Directory:
    """Directory."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DirectoryInput:
    """DirectoryInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdatedDirectoryInput:
    """UpdatedDirectoryInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SchemaResult:
    """SchemaResult."""

    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))
    extractors: Optional[str] = field(
        default=None, metadata=config(field_name="extractors")
    )
    errors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="errors")
    )
    fields: Optional[List[dict]] = field(
        default=None, metadata=config(field_name="fields")
    )
    variables: Optional[List[dict]] = field(
        default=None, metadata=config(field_name="variables")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ParserFilterInput:
    """ParserFilterInput."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DirectoryFilterInput:
    """DirectoryFilterInput."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Sample:
    """Sample."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    sample_text: Optional[str] = field(
        default=None, metadata=config(field_name="sampleText")
    )
    parser_id: Optional[int] = field(
        default=None, metadata=config(field_name="parserId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateSampleInput:
    """CreateSampleInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    sample_text: Optional[str] = field(
        default=None, metadata=config(field_name="sampleText")
    )
    parser_id: Optional[int] = field(
        default=None, metadata=config(field_name="parserId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdatedSampleInput:
    """UpdatedSampleInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    sample_text: Optional[str] = field(
        default=None, metadata=config(field_name="sampleText")
    )
    parser_id: Optional[int] = field(
        default=None, metadata=config(field_name="parserId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SampleFilterInput:
    """SampleFilterInput."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CountsForSensorType:
    """CountsForSensorType."""

    sending_host_counts: Optional[List[CountsForSendingHost]] = field(
        default=None, metadata=config(field_name="sendingHostCounts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SampleResult:
    """SampleResult."""

    message: Optional[str] = field(default=None, metadata=config(field_name="message"))
    results: Optional[List[SchemaResult]] = field(
        default=None, metadata=config(field_name="results")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ParserInput:
    """ParserInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    schema_: Optional[str] = field(default=None, metadata=config(field_name="schema"))
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    parent_id: Optional[int] = field(
        default=None, metadata=config(field_name="parentId")
    )
    directory_id: Optional[int] = field(
        default=None, metadata=config(field_name="directoryId")
    )
    disabled: Optional[bool] = field(
        default=None, metadata=config(field_name="disabled")
    )
    type: Optional[ParserType] = field(default=None, metadata=config(field_name="type"))
    format: Optional[ParserFormatType] = field(
        default=None, metadata=config(field_name="format")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CountsForService:
    """CountsForService."""

    sensor_type_counts: Optional[List[CountsForSensorType]] = field(
        default=None, metadata=config(field_name="sensorTypeCounts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CountsForCollector:
    """CountsForCollector."""

    service_counts: Optional[List[CountsForService]] = field(
        default=None, metadata=config(field_name="serviceCounts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SyslogMessageCount:
    """SyslogMessageCount."""

    collectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="collectors")
    )
    services: Optional[List[str]] = field(
        default=None, metadata=config(field_name="services")
    )
    sensor_types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sensorTypes")
    )
    sending_hosts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sendingHosts")
    )
    schemas: Optional[List[str]] = field(
        default=None, metadata=config(field_name="schemas")
    )
    collector_counts: Optional[List[CountsForCollector]] = field(
        default=None, metadata=config(field_name="collectorCounts")
    )
