"""TenantProfiles Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.tenant_profiles.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.tenant_profiles import TenantProfilesService

log = logging.getLogger(__name__)


class TaegisSDKTenantProfilesQuery:
    """Teagis Tenant_profiles Query operations."""

    def __init__(self, service: TenantProfilesService):
        self.service = service

    def managed_tenant_profile(self) -> ManagedTenantProfile:
        """None."""
        endpoint = "managedTenantProfile"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(ManagedTenantProfile),
        )
        if result.get(endpoint) is not None:
            return ManagedTenantProfile.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query managedTenantProfile")

    def cse_contacts_mtp(self) -> CseCustomerContacts:
        """None."""
        endpoint = "cseContactsMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(CseCustomerContacts),
        )
        if result.get(endpoint) is not None:
            return CseCustomerContacts.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query cseContactsMtp")

    def version_mtp(self) -> VersionMtp:
        """None."""
        endpoint = "versionMtp"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(VersionMtp)
        )
        if result.get(endpoint) is not None:
            return VersionMtp.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query versionMtp")

    def network_ranges_mtp(self) -> List[NetworkRangeMtp]:
        """None."""
        endpoint = "networkRangesMtp"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(NetworkRangeMtp)
        )
        if result.get(endpoint) is not None:
            return NetworkRangeMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query networkRangesMtp")

    def search_network_ranges_mtp(self, ip_address: str) -> List[NetworkRangeMtp]:
        """None."""
        endpoint = "searchNetworkRangesMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ipAddress": prepare_input(ip_address),
            },
            output=build_output_string(NetworkRangeMtp),
        )
        if result.get(endpoint) is not None:
            return NetworkRangeMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query searchNetworkRangesMtp")

    def find_network_range_cidr_mtp(self, cidr: str) -> List[NetworkRangeMtp]:
        """None."""
        endpoint = "findNetworkRangeCidrMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "cidr": prepare_input(cidr),
            },
            output=build_output_string(NetworkRangeMtp),
        )
        if result.get(endpoint) is not None:
            return NetworkRangeMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query findNetworkRangeCidrMtp")

    def note_mtp(self) -> NoteMtp:
        """retrieve the single note available for a tenant. A note will be created with an ID on first retrieval."""
        endpoint = "noteMtp"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(NoteMtp)
        )
        if result.get(endpoint) is not None:
            return NoteMtp.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query noteMtp")

    def security_controls_mtp(self) -> List[SecurityControlMtp]:
        """None."""
        endpoint = "securityControlsMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(SecurityControlMtp),
        )
        if result.get(endpoint) is not None:
            return SecurityControlMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query securityControlsMtp")

    def mfa_accesses_mtp(self) -> List[MfaAccessMtp]:
        """None."""
        endpoint = "mfaAccessesMtp"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(MfaAccessMtp)
        )
        if result.get(endpoint) is not None:
            return MfaAccessMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query mfaAccessesMtp")

    def file_attachments_mtp(
        self, include_all_versions: Optional[bool] = None
    ) -> List[FileAttachmentMtp]:
        """Retrieve all file attachments for the current tenant. Returns only current files unless `includeAllVersions` is true."""
        endpoint = "fileAttachmentsMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "includeAllVersions": prepare_input(include_all_versions),
            },
            output=build_output_string(FileAttachmentMtp),
        )
        if result.get(endpoint) is not None:
            return FileAttachmentMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query fileAttachmentsMtp")

    def file_attachment_mtp(self, id_: str) -> FileAttachmentMtp:
        """Retrieve details for a single file attachment by attachment ID."""
        endpoint = "fileAttachmentMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(FileAttachmentMtp),
        )
        if result.get(endpoint) is not None:
            return FileAttachmentMtp.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query fileAttachmentMtp")

    def file_attachment_by_name_mtp(
        self, filename: str, version: Optional[int] = None
    ) -> FileAttachmentMtp:
        """Retrieve details for a specific version of a file attachment. The latest version is returned unless specified."""
        endpoint = "fileAttachmentByNameMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filename": prepare_input(filename),
                "version": prepare_input(version),
            },
            output=build_output_string(FileAttachmentMtp),
        )
        if result.get(endpoint) is not None:
            return FileAttachmentMtp.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query fileAttachmentByNameMtp")

    def file_versions_by_name_mtp(self, filename: str) -> List[FileAttachmentMtp]:
        """Retrieve details for all versions of a single file attachment."""
        endpoint = "fileVersionsByNameMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filename": prepare_input(filename),
            },
            output=build_output_string(FileAttachmentMtp),
        )
        if result.get(endpoint) is not None:
            return FileAttachmentMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query fileVersionsByNameMtp")

    def download_attachments_mtp(self, ids: List[str]) -> List[FileDownloadMtp]:
        """Create download URLs for one or more attachments, by attachment IDs."""
        endpoint = "downloadAttachmentsMtp"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ids": prepare_input(ids),
            },
            output=build_output_string(FileDownloadMtp),
        )
        if result.get(endpoint) is not None:
            return FileDownloadMtp.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query downloadAttachmentsMtp")
