import * as ecr from '@aws-cdk/aws-ecr';
import { Construct } from 'constructs';
import { IAsset } from '@aws-cdk/assets';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options for TarballImageAsset.
 *
 * @stability stable
 */
export interface TarballImageAssetProps {
    /**
     * Path to the tarball.
     *
     * @stability stable
     */
    readonly tarballFile: string;
}
/**
 * An asset that represents a Docker image.
 *
 * The image will loaded from an existing tarball and uploaded to an ECR repository.
 *
 * @stability stable
 */
export declare class TarballImageAsset extends CoreConstruct implements IAsset {
    /**
     * The full URI of the image (including a tag).
     *
     * Use this reference to pull
     * the asset.
     *
     * @stability stable
     */
    imageUri: string;
    /**
     * Repository where the image is stored.
     *
     * @stability stable
     */
    repository: ecr.IRepository;
    /**
     * (deprecated) A hash of the source of this asset, which is available at construction time.
     *
     * As this is a plain
     * string, it can be used in construct IDs in order to enforce creation of a new resource when
     * the content hash has changed.
     *
     * @deprecated use assetHash
     */
    readonly sourceHash: string;
    /**
     * A hash of this asset, which is available at construction time.
     *
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     *
     * @stability stable
     */
    readonly assetHash: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: TarballImageAssetProps);
}
