"""initial schema

Revision ID: 3dae7c7b1564
Revises:
Create Date: 2025-02-12 21:23:00.336344

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "3dae7c7b1564"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "entity",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("entity_type", sa.String(), nullable=False),
        sa.Column("entity_metadata", sa.JSON(), nullable=True),
        sa.Column("content_type", sa.String(), nullable=False),
        sa.Column("permalink", sa.String(), nullable=False),
        sa.Column("file_path", sa.String(), nullable=False),
        sa.Column("checksum", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("permalink", name="uix_entity_permalink"),
    )
    op.create_index("ix_entity_created_at", "entity", ["created_at"], unique=False)
    op.create_index(op.f("ix_entity_file_path"), "entity", ["file_path"], unique=True)
    op.create_index(op.f("ix_entity_permalink"), "entity", ["permalink"], unique=True)
    op.create_index("ix_entity_title", "entity", ["title"], unique=False)
    op.create_index("ix_entity_type", "entity", ["entity_type"], unique=False)
    op.create_index("ix_entity_updated_at", "entity", ["updated_at"], unique=False)
    op.create_table(
        "observation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("entity_id", sa.Integer(), nullable=False),
        sa.Column("content", sa.Text(), nullable=False),
        sa.Column("category", sa.String(), nullable=False),
        sa.Column("context", sa.Text(), nullable=True),
        sa.Column("tags", sa.JSON(), server_default="[]", nullable=True),
        sa.ForeignKeyConstraint(["entity_id"], ["entity.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index("ix_observation_category", "observation", ["category"], unique=False)
    op.create_index("ix_observation_entity_id", "observation", ["entity_id"], unique=False)
    op.create_table(
        "relation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("from_id", sa.Integer(), nullable=False),
        sa.Column("to_id", sa.Integer(), nullable=True),
        sa.Column("to_name", sa.String(), nullable=False),
        sa.Column("relation_type", sa.String(), nullable=False),
        sa.Column("context", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(["from_id"], ["entity.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["to_id"], ["entity.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("from_id", "to_id", "relation_type", name="uix_relation"),
    )
    op.create_index("ix_relation_from_id", "relation", ["from_id"], unique=False)
    op.create_index("ix_relation_to_id", "relation", ["to_id"], unique=False)
    op.create_index("ix_relation_type", "relation", ["relation_type"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_relation_type", table_name="relation")
    op.drop_index("ix_relation_to_id", table_name="relation")
    op.drop_index("ix_relation_from_id", table_name="relation")
    op.drop_table("relation")
    op.drop_index("ix_observation_entity_id", table_name="observation")
    op.drop_index("ix_observation_category", table_name="observation")
    op.drop_table("observation")
    op.drop_index("ix_entity_updated_at", table_name="entity")
    op.drop_index("ix_entity_type", table_name="entity")
    op.drop_index("ix_entity_title", table_name="entity")
    op.drop_index(op.f("ix_entity_permalink"), table_name="entity")
    op.drop_index(op.f("ix_entity_file_path"), table_name="entity")
    op.drop_index("ix_entity_created_at", table_name="entity")
    op.drop_table("entity")
    # ### end Alembic commands ###
