from pathlib import Path
from typing import Any

import yaml

from tesorotools.dependencies.node import Node
from tesorotools.dependencies.resolution import resolve_series


def compile_series(
    config_dicts: list[dict[str, Any]],
    dependencies_cfg: dict[str, Any],
    out: Path,
) -> dict[str, list[str]]:
    """Generates a document with all the series used in the document. Useful when you want to download them all at once."""

    resolved_dict = resolve_series(
        config_dicts,
        dependencies_cfg,
    )

    dependent_series: list[Node] = resolved_dict["dependent"]
    dependent_series_id_list: list[str] = [
        node.name for node in dependent_series
    ]
    independent_series_id_list: list[str] = list(resolved_dict["independent"])
    result = {
        "dependent": dependent_series_id_list,
        "independent": independent_series_id_list,
    }

    with open(out, "w", encoding="utf-8") as stream:
        comment: str = "# Autogenerated document, do not touch!\n\n"
        stream.write(comment)
        yaml.dump(
            result,
            stream,
        )

    return result
