import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementEmailTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#api_management_name ApiManagementEmailTemplate#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#body ApiManagementEmailTemplate#body}
    */
    readonly body: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#resource_group_name ApiManagementEmailTemplate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#subject ApiManagementEmailTemplate#subject}
    */
    readonly subject: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#template_name ApiManagementEmailTemplate#template_name}
    */
    readonly templateName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#timeouts ApiManagementEmailTemplate#timeouts}
    */
    readonly timeouts?: ApiManagementEmailTemplateTimeouts;
}
export interface ApiManagementEmailTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#create ApiManagementEmailTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#delete ApiManagementEmailTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#read ApiManagementEmailTemplate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template#update ApiManagementEmailTemplate#update}
    */
    readonly update?: string;
}
export declare function apiManagementEmailTemplateTimeoutsToTerraform(struct?: ApiManagementEmailTemplateTimeoutsOutputReference | ApiManagementEmailTemplateTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementEmailTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementEmailTemplateTimeouts | undefined;
    set internalValue(value: ApiManagementEmailTemplateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template azurerm_api_management_email_template}
*/
export declare class ApiManagementEmailTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_email_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template azurerm_api_management_email_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementEmailTemplateConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementEmailTemplateConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    get description(): string;
    get id(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    get subjectInput(): string | undefined;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    get templateNameInput(): string | undefined;
    get title(): string;
    private _timeouts;
    get timeouts(): ApiManagementEmailTemplateTimeoutsOutputReference;
    putTimeouts(value: ApiManagementEmailTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementEmailTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
