import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementGatewayApiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#api_id ApiManagementGatewayApi#api_id}
    */
    readonly apiId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#gateway_id ApiManagementGatewayApi#gateway_id}
    */
    readonly gatewayId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#timeouts ApiManagementGatewayApi#timeouts}
    */
    readonly timeouts?: ApiManagementGatewayApiTimeouts;
}
export interface ApiManagementGatewayApiTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#create ApiManagementGatewayApi#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#delete ApiManagementGatewayApi#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#read ApiManagementGatewayApi#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api#update ApiManagementGatewayApi#update}
    */
    readonly update?: string;
}
export declare function apiManagementGatewayApiTimeoutsToTerraform(struct?: ApiManagementGatewayApiTimeoutsOutputReference | ApiManagementGatewayApiTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementGatewayApiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementGatewayApiTimeouts | undefined;
    set internalValue(value: ApiManagementGatewayApiTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api azurerm_api_management_gateway_api}
*/
export declare class ApiManagementGatewayApi extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_gateway_api";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway_api azurerm_api_management_gateway_api} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementGatewayApiConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementGatewayApiConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    get apiIdInput(): string | undefined;
    private _gatewayId?;
    get gatewayId(): string;
    set gatewayId(value: string);
    get gatewayIdInput(): string | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): ApiManagementGatewayApiTimeoutsOutputReference;
    putTimeouts(value: ApiManagementGatewayApiTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementGatewayApiTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
