import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementIdentityProviderFacebookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#api_management_name ApiManagementIdentityProviderFacebook#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#app_id ApiManagementIdentityProviderFacebook#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#app_secret ApiManagementIdentityProviderFacebook#app_secret}
    */
    readonly appSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#resource_group_name ApiManagementIdentityProviderFacebook#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#timeouts ApiManagementIdentityProviderFacebook#timeouts}
    */
    readonly timeouts?: ApiManagementIdentityProviderFacebookTimeouts;
}
export interface ApiManagementIdentityProviderFacebookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#create ApiManagementIdentityProviderFacebook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#delete ApiManagementIdentityProviderFacebook#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#read ApiManagementIdentityProviderFacebook#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook#update ApiManagementIdentityProviderFacebook#update}
    */
    readonly update?: string;
}
export declare function apiManagementIdentityProviderFacebookTimeoutsToTerraform(struct?: ApiManagementIdentityProviderFacebookTimeoutsOutputReference | ApiManagementIdentityProviderFacebookTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementIdentityProviderFacebookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementIdentityProviderFacebookTimeouts | undefined;
    set internalValue(value: ApiManagementIdentityProviderFacebookTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook azurerm_api_management_identity_provider_facebook}
*/
export declare class ApiManagementIdentityProviderFacebook extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_identity_provider_facebook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_facebook azurerm_api_management_identity_provider_facebook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementIdentityProviderFacebookConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementIdentityProviderFacebookConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    get appSecretInput(): string | undefined;
    get id(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementIdentityProviderFacebookTimeoutsOutputReference;
    putTimeouts(value: ApiManagementIdentityProviderFacebookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementIdentityProviderFacebookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
