import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#api_management_id ApiManagementPolicyA#api_management_id}
    */
    readonly apiManagementId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#xml_content ApiManagementPolicyA#xml_content}
    */
    readonly xmlContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#xml_link ApiManagementPolicyA#xml_link}
    */
    readonly xmlLink?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#timeouts ApiManagementPolicyA#timeouts}
    */
    readonly timeouts?: ApiManagementPolicyTimeouts;
}
export interface ApiManagementPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#create ApiManagementPolicyA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#delete ApiManagementPolicyA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#read ApiManagementPolicyA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy#update ApiManagementPolicyA#update}
    */
    readonly update?: string;
}
export declare function apiManagementPolicyTimeoutsToTerraform(struct?: ApiManagementPolicyTimeoutsOutputReference | ApiManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementPolicyTimeouts | undefined;
    set internalValue(value: ApiManagementPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy azurerm_api_management_policy}
*/
export declare class ApiManagementPolicyA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy azurerm_api_management_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementPolicyAConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementPolicyAConfig);
    private _apiManagementId?;
    get apiManagementId(): string;
    set apiManagementId(value: string);
    get apiManagementIdInput(): string | undefined;
    get id(): string;
    private _xmlContent?;
    get xmlContent(): string;
    set xmlContent(value: string);
    resetXmlContent(): void;
    get xmlContentInput(): string | undefined;
    private _xmlLink?;
    get xmlLink(): string;
    set xmlLink(value: string);
    resetXmlLink(): void;
    get xmlLinkInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementPolicyTimeoutsOutputReference;
    putTimeouts(value: ApiManagementPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
