import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#allow_tracing ApiManagementSubscription#allow_tracing}
    */
    readonly allowTracing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#api_id ApiManagementSubscription#api_id}
    */
    readonly apiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#api_management_name ApiManagementSubscription#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#display_name ApiManagementSubscription#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#primary_key ApiManagementSubscription#primary_key}
    */
    readonly primaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#product_id ApiManagementSubscription#product_id}
    */
    readonly productId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#resource_group_name ApiManagementSubscription#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#secondary_key ApiManagementSubscription#secondary_key}
    */
    readonly secondaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#state ApiManagementSubscription#state}
    */
    readonly state?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#subscription_id ApiManagementSubscription#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#user_id ApiManagementSubscription#user_id}
    */
    readonly userId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#timeouts ApiManagementSubscription#timeouts}
    */
    readonly timeouts?: ApiManagementSubscriptionTimeouts;
}
export interface ApiManagementSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#create ApiManagementSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#delete ApiManagementSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#read ApiManagementSubscription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription#update ApiManagementSubscription#update}
    */
    readonly update?: string;
}
export declare function apiManagementSubscriptionTimeoutsToTerraform(struct?: ApiManagementSubscriptionTimeoutsOutputReference | ApiManagementSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementSubscriptionTimeouts | undefined;
    set internalValue(value: ApiManagementSubscriptionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription azurerm_api_management_subscription}
*/
export declare class ApiManagementSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_subscription azurerm_api_management_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementSubscriptionConfig);
    private _allowTracing?;
    get allowTracing(): boolean | cdktf.IResolvable;
    set allowTracing(value: boolean | cdktf.IResolvable);
    resetAllowTracing(): void;
    get allowTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    resetApiId(): void;
    get apiIdInput(): string | undefined;
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    resetPrimaryKey(): void;
    get primaryKeyInput(): string | undefined;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    resetProductId(): void;
    get productIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secondaryKey?;
    get secondaryKey(): string;
    set secondaryKey(value: string);
    resetSecondaryKey(): void;
    get secondaryKeyInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementSubscriptionTimeoutsOutputReference;
    putTimeouts(value: ApiManagementSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
